/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.BasicZipInputStreamSupplier;
import org.jcvi.jillion.core.io.GZipInputStreamSupplier;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.io.RawFileInputStreamSupplier;
import org.jcvi.jillion.core.io.SubLengthInputStream;
import org.jcvi.jillion.internal.core.io.MagicNumberInputStream;

@FunctionalInterface
public interface InputStreamSupplier {
    public InputStream get() throws IOException;

    default public InputStream get(long startOffset) throws IOException {
        InputStream in = this.get();
        IOUtil.blockingSkip(in, startOffset);
        return in;
    }

    default public InputStream get(Range range) throws IOException {
        InputStream in = this.get(range.getBegin());
        return new SubLengthInputStream(in, range.getLength());
    }

    default public Optional<File> getFile() {
        return Optional.empty();
    }

    public static InputStreamSupplier forFile(File f) throws IOException {
        byte[] magicNumber;
        IOUtil.verifyIsReadable(f);
        if (f.length() == 0L) {
            return new RawFileInputStreamSupplier(f);
        }
        try (MagicNumberInputStream magicNumInputStream = new MagicNumberInputStream(f);){
            magicNumber = magicNumInputStream.peekMagicNumber();
        }
        if (magicNumber[0] == 80 && magicNumber[1] == 75 && magicNumber[2] == 3 && magicNumber[3] == 4) {
            return new BasicZipInputStreamSupplier(f);
        }
        if (magicNumber[0] == 31 && magicNumber[1] == -117) {
            return new GZipInputStreamSupplier(f);
        }
        return new RawFileInputStreamSupplier(f);
    }
}

