/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.Scanner;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;

public final class IOUtil {
    private static final int EOF = -1;
    private static final double LOG_2 = Math.log(2.0);
    public static final String UTF_8_NAME = "UTF-8";
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    private IOUtil() {
    }

    public static void recursiveDelete(File dir) throws IOException {
        if (dir.exists()) {
            IOUtil.deleteChildren(dir);
            IOUtil.delete(dir);
        }
    }

    public static void deleteChildren(File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            for (File subfile : dir.listFiles()) {
                IOUtil.recursiveDelete(subfile);
            }
        }
    }

    public static void delete(File file) throws IOException {
        if (file != null) {
            Files.deleteIfExists(file.toPath());
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="This method exists solely so we don't have file.delete()s without checking return values littered throughout the codebase.")
    public static void deleteIgnoreError(File file) {
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static void mkdirs(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("unable to mkdirs for " + dir);
        }
    }

    public static void mkdir(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdir()) {
            throw new IOException("unable to mkdir for " + dir);
        }
    }

    public static void closeAndIgnoreErrors(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeAndIgnoreErrors(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            IOUtil.closeAndIgnoreErrors(closeable);
        }
    }

    public static void closeAndIgnoreErrors(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeAndIgnoreErrors(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeAndIgnoreErrors(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeAndIgnoreErrors(Scanner scanner) {
        if (scanner != null) {
            scanner.close();
        }
    }

    public static void blockingSkip(InputStream in, long numberOfBytes) throws IOException {
        for (long leftToSkip = numberOfBytes; leftToSkip > 0L; leftToSkip -= in.skip(leftToSkip - 1L) + 1L) {
            int value = in.read();
            if (value != -1) continue;
            throw new IOException("end of file reached before entire block was skipped");
        }
    }

    public static void blockingRead(InputStream in, byte[] buf) throws IOException {
        IOUtil.blockingRead(in, buf, 0, buf.length);
    }

    public static void blockingRead(RandomAccessFile file, byte[] buf) throws IOException {
        IOUtil.blockingRead(file, buf, 0, buf.length);
    }

    public static void blockingRead(InputStream in, byte[] buf, int offset, int length) throws IOException {
        IOUtil.checkBlockingReadInputsAreOK(in, buf, offset, length);
        int currentBytesRead = 0;
        int totalBytesRead = 0;
        while ((currentBytesRead = in.read(buf, offset + totalBytesRead, length - totalBytesRead)) > 0 && (totalBytesRead += currentBytesRead) != length) {
        }
        if (currentBytesRead == -1) {
            throw new EOFException(String.format("end of file after only %d bytes read (expected %d)", totalBytesRead, length));
        }
    }

    public static void blockingRead(RandomAccessFile file, byte[] buf, int offset, int length) throws IOException {
        IOUtil.checkBlockingReadInputsAreOK(file, buf, offset, length);
        int currentBytesRead = 0;
        int totalBytesRead = 0;
        while ((currentBytesRead = file.read(buf, offset + totalBytesRead, length - totalBytesRead)) > 0 && (totalBytesRead += currentBytesRead) != length) {
        }
        if (currentBytesRead == -1) {
            throw new EOFException(String.format("end of file after only %d bytes read (expected %d)", totalBytesRead, length));
        }
    }

    private static void checkBlockingReadInputsAreOK(InputStream in, byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("byte array can not be null");
        }
        if (in == null) {
            throw new NullPointerException("inputstream can not be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
    }

    private static void checkBlockingReadInputsAreOK(RandomAccessFile in, byte[] buf, int offset, int length) {
        if (buf == null) {
            throw new NullPointerException("byte array can not be null");
        }
        if (in == null) {
            throw new NullPointerException("inputstream can not be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
    }

    public static short[] readUnsignedByteArray(InputStream in, int expectedLength) throws IOException {
        short[] array = new short[expectedLength];
        for (int i = 0; i < expectedLength; ++i) {
            array[i] = (short)in.read();
        }
        return array;
    }

    public static short[] readShortArray(InputStream in, int numberOfShortsToRead) throws IOException {
        short[] array = new short[numberOfShortsToRead];
        for (int i = 0; i < numberOfShortsToRead; ++i) {
            array[i] = IOUtil.readSignedShort(in);
        }
        return array;
    }

    public static byte[] readByteArray(InputStream in, int length) throws IOException {
        byte[] array = new byte[length];
        IOUtil.blockingRead(in, array);
        return array;
    }

    public static int[] readIntArray(InputStream in, int numberOfIntsToRead) throws IOException {
        int[] array = new int[numberOfIntsToRead];
        for (int i = 0; i < numberOfIntsToRead; ++i) {
            array[i] = IOUtil.readSignedInt(in);
        }
        return array;
    }

    public static long[] readLongArray(InputStream in, int numberOfLongsToRead, ByteOrder endian) throws IOException {
        long[] array = new long[numberOfLongsToRead];
        for (int i = 0; i < numberOfLongsToRead; ++i) {
            array[i] = IOUtil.readSignedLong(in, endian);
        }
        return array;
    }

    public static long readSignedLong(InputStream in) throws IOException {
        return IOUtil.readSignedLong(in, ByteOrder.BIG_ENDIAN);
    }

    public static long readSignedLong(InputStream in, ByteOrder endian) throws IOException {
        byte[] b = IOUtil.readByteArray(in, 8);
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            return ((long)b[7] << 56) + ((long)(b[6] & 0xFF) << 48) + ((long)(b[5] & 0xFF) << 40) + ((long)(b[4] & 0xFF) << 32) + ((long)(b[3] & 0xFF) << 24) + (long)((b[2] & 0xFF) << 16) + (long)((b[1] & 0xFF) << 8) + (long)((b[0] & 0xFF) << 0);
        }
        return ((long)b[0] << 56) + ((long)(b[1] & 0xFF) << 48) + ((long)(b[2] & 0xFF) << 40) + ((long)(b[3] & 0xFF) << 32) + ((long)(b[4] & 0xFF) << 24) + (long)((b[5] & 0xFF) << 16) + (long)((b[6] & 0xFF) << 8) + (long)((b[7] & 0xFF) << 0);
    }

    public static float[] readFloatArray(InputStream in, int numberOfFloatsToRead) throws IOException {
        float[] array = new float[numberOfFloatsToRead];
        for (int i = 0; i < numberOfFloatsToRead; ++i) {
            array[i] = IOUtil.readFloat(in);
        }
        return array;
    }

    public static void putShortArray(ByteBuffer buf, short[] array) {
        for (int i = 0; i < array.length; ++i) {
            buf.putShort(array[i]);
        }
    }

    public static void putUnsignedByteArray(ByteBuffer buf, short[] array) {
        for (int i = 0; i < array.length; ++i) {
            buf.put((byte)array[i]);
        }
    }

    public static int toUnsignedByte(byte value) {
        return value & 0xFF;
    }

    public static byte toSignedByte(int unsignedByte) {
        if (unsignedByte > 127) {
            return (byte)(unsignedByte - 256);
        }
        return (byte)unsignedByte;
    }

    public static short toSignedShort(int unsignedShort) {
        if (unsignedShort > Short.MAX_VALUE) {
            return (short)(unsignedShort - 65536);
        }
        return (short)unsignedShort;
    }

    public static int toSignedInt(long unsignedInt) {
        if (unsignedInt > Integer.MAX_VALUE) {
            return (int)(unsignedInt - 0L);
        }
        return (int)unsignedInt;
    }

    public static int toUnsignedShort(short value) {
        return value & 0xFFFF;
    }

    public static long toUnsignedInt(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static byte[] switchEndian(byte[] byteArray) {
        byte[] newByteArray = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length / 2; ++i) {
            newByteArray[i] = byteArray[byteArray.length - 1 - i];
            newByteArray[byteArray.length - 1 - i] = byteArray[i];
        }
        if (byteArray.length % 2 == 1) {
            int center = byteArray.length / 2;
            newByteArray[center] = byteArray[center];
        }
        return newByteArray;
    }

    public static long readUnsignedInt(InputStream in, ByteOrder endian) throws IOException {
        byte[] array = IOUtil.toByteArray(in, 4);
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            long tmp = ((long)array[3] & 0xFFL) << 24;
            tmp |= (long)((array[2] & 0xFF) << 16);
            tmp |= (long)((array[1] & 0xFF) << 8);
            return tmp |= (long)(array[0] & 0xFF);
        }
        long tmp = ((long)array[0] & 0xFFL) << 24;
        tmp |= (long)((array[1] & 0xFF) << 16);
        tmp |= (long)((array[2] & 0xFF) << 8);
        return tmp |= (long)(array[3] & 0xFF);
    }

    public static int readUnsignedShort(InputStream in, ByteOrder endian) throws IOException {
        byte[] array = IOUtil.toByteArray(in, 2);
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            int tmp = (array[1] & 0xFF) << 8;
            return tmp |= array[0] & 0xFF;
        }
        int tmp = (array[0] & 0xFF) << 8;
        return tmp |= array[1] & 0xFF;
    }

    public static short readUnsignedByte(InputStream in, ByteOrder endian) throws IOException {
        int value = in.read();
        if (value == -1) {
            throw new EOFException();
        }
        return (short)value;
    }

    public static short readSignedShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static int readSignedInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static int readSignedInt(InputStream in, ByteOrder endian) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void putInt(OutputStream out, int value, ByteOrder endian) throws IOException {
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            out.write(value >>> 0 & 0xFF);
            out.write(value >>> 8 & 0xFF);
            out.write(value >>> 16 & 0xFF);
            out.write(value >>> 24 & 0xFF);
        } else {
            out.write(value >>> 24 & 0xFF);
            out.write(value >>> 16 & 0xFF);
            out.write(value >>> 8 & 0xFF);
            out.write(value >>> 0 & 0xFF);
        }
    }

    public static void putLong(OutputStream out, long value, ByteOrder endian) throws IOException {
        byte[] writeBuffer = new byte[8];
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            writeBuffer[0] = (byte)(value >>> 0);
            writeBuffer[1] = (byte)(value >>> 8);
            writeBuffer[2] = (byte)(value >>> 16);
            writeBuffer[3] = (byte)(value >>> 24);
            writeBuffer[4] = (byte)(value >>> 32);
            writeBuffer[5] = (byte)(value >>> 40);
            writeBuffer[6] = (byte)(value >>> 48);
            writeBuffer[7] = (byte)(value >>> 56);
        } else {
            writeBuffer[0] = (byte)(value >>> 56);
            writeBuffer[1] = (byte)(value >>> 48);
            writeBuffer[2] = (byte)(value >>> 40);
            writeBuffer[3] = (byte)(value >>> 32);
            writeBuffer[4] = (byte)(value >>> 24);
            writeBuffer[5] = (byte)(value >>> 16);
            writeBuffer[6] = (byte)(value >>> 8);
            writeBuffer[7] = (byte)(value >>> 0);
        }
        out.write(writeBuffer, 0, 8);
    }

    public static float readFloat(InputStream in) throws IOException {
        return Float.intBitsToFloat(IOUtil.readSignedInt(in));
    }

    public static BigInteger getUnsignedLong(ByteBuffer buf) throws IOException {
        byte[] tmp = new byte[8];
        buf.get(tmp);
        return new BigInteger(1, tmp);
    }

    public static long getUnsignedInt(ByteBuffer buf) throws IOException {
        byte[] tmp = new byte[4];
        buf.get(tmp);
        return new BigInteger(1, tmp).longValue();
    }

    public static int getUnsignedShort(ByteBuffer buf) throws IOException {
        byte[] tmp = new byte[2];
        buf.get(tmp);
        return new BigInteger(1, tmp).intValue();
    }

    public static short getUnsignedByte(ByteBuffer buf) throws IOException {
        byte[] tmp = new byte[1];
        buf.get(tmp);
        return new BigInteger(1, tmp).shortValue();
    }

    public static BigInteger readUnsignedLong(InputStream in) throws IOException {
        return IOUtil.readUnsignedLong(in, ByteOrder.BIG_ENDIAN);
    }

    public static BigInteger readUnsignedLong(InputStream in, ByteOrder endian) throws IOException {
        return new BigInteger(1, IOUtil.toByteArray(in, 8, endian));
    }

    public static long readUnsignedInt(InputStream in) throws IOException {
        return IOUtil.readUnsignedInt(in, ByteOrder.BIG_ENDIAN);
    }

    public static int readUnsignedShort(InputStream in) throws IOException {
        return IOUtil.readUnsignedShort(in, ByteOrder.BIG_ENDIAN);
    }

    public static short readUnsignedByte(InputStream in) throws IOException {
        return IOUtil.readUnsignedByte(in, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] convertUnsignedIntToByteArray(long unsignedInt) {
        byte[] result = new byte[4];
        long currentValue = unsignedInt;
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (byte)(currentValue & 0xFFL);
            currentValue >>>= 8;
        }
        return result;
    }

    public static byte[] convertUnsignedShortToByteArray(int unsignedShort) {
        if (unsignedShort < 0) {
            throw new IllegalArgumentException("unsigned value can not be negative");
        }
        byte[] result = new byte[2];
        int currentValue = unsignedShort;
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (byte)(currentValue & 0xFF);
            currentValue >>>= 8;
        }
        return result;
    }

    public static byte[] convertUnsignedByteToByteArray(short unsignedByte) {
        byte[] result = new byte[]{(byte)(unsignedByte & 0xFF)};
        return result;
    }

    public static byte[] convertUnsignedLongToByteArray(BigInteger unsignedLong) {
        String hexString = IOUtil.convertToPaddedHex(unsignedLong, 16);
        byte[] result = new byte[8];
        for (int i = 0; i < 16; i += 2) {
            String byteInHex = hexString.substring(i, i + 2);
            result[i / 2] = (byte)Short.parseShort(byteInHex, 16);
        }
        return result;
    }

    private static String convertToPaddedHex(BigInteger value, int maxNumberOfHexChars) {
        String hexString = value.toString(16);
        int padding = maxNumberOfHexChars - hexString.length();
        StringBuilder paddingString = new StringBuilder(maxNumberOfHexChars);
        for (int i = 0; i < padding; ++i) {
            paddingString.append('0');
        }
        paddingString.append(hexString);
        return paddingString.toString();
    }

    public static InputStream createInputStreamFromFile(File file, long startOffset, int length) throws IOException {
        return new RandomAccessFileInputStream(file, startOffset, length);
    }

    public static int getUnsignedBitCount(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value can not be <0");
        }
        if (value == Long.MAX_VALUE) {
            return 64;
        }
        return (int)Math.ceil(Math.log(value + 1L) / LOG_2);
    }

    public static int getUnsignedByteCount(long value) {
        int numBits = IOUtil.getUnsignedBitCount(value);
        return (numBits + 7) / 8;
    }

    public static byte[] toByteArray(BitSet bitset, int bitLength) {
        if (bitset == null) {
            throw new NullPointerException("bitset can not be null");
        }
        if (bitLength < 0) {
            throw new IllegalArgumentException("bitLength must be >=0");
        }
        byte[] bytes = new byte[(bitLength + 7) / 8];
        for (int i = 0; i < bitLength; ++i) {
            if (!bitset.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static BitSet toBitSet(byte[] bytes) {
        BitSet bits = new BitSet();
        int maxNumberOfBits = bytes.length * 8;
        for (int i = 0; i < maxNumberOfBits; ++i) {
            int value = bytes[bytes.length - i / 8 - 1] & 1 << i % 8;
            if (value == 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static BitSet toBitSet(ByteBuffer buffer) {
        BitSet bits = new BitSet(8 * buffer.remaining());
        int j = 0;
        while (buffer.remaining() > 0) {
            byte value = buffer.get();
            for (int i = 0; i < 8; ++i) {
                int bit = value & 1 << i;
                if (bit == 0) continue;
                bits.set(j + i);
            }
            j += 8;
        }
        return bits;
    }

    public static BitSet toBitSet(long singleValue) {
        return IOUtil.toBitSet(BigInteger.valueOf(singleValue).toByteArray());
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        int numBytesRead;
        byte[] buf = new byte[2048];
        long numBytesCopied = 0L;
        while ((numBytesRead = in.read(buf)) != -1) {
            numBytesCopied += (long)numBytesRead;
            out.write(buf, 0, numBytesRead);
            out.flush();
        }
        return numBytesCopied;
    }

    public static String toString(InputStream in) throws IOException {
        return IOUtil.toString(in, null);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        int numBytesRead;
        StringWriter writer = new StringWriter();
        InputStreamReader reader = encoding == null ? new InputStreamReader(in, Charset.defaultCharset()) : new InputStreamReader(in, encoding);
        char[] buf = new char[1024];
        while ((numBytesRead = reader.read(buf)) != -1) {
            writer.write(buf, 0, numBytesRead);
        }
        return writer.toString();
    }

    public static byte[] toByteArray(File f) throws IOException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            byArray = IOUtil.toByteArray(in);
        }
        catch (Throwable throwable) {
            IOUtil.closeAndIgnoreErrors(in);
            throw throwable;
        }
        IOUtil.closeAndIgnoreErrors((Closeable)in);
        return byArray;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(InputStream in, int numberOfBytesToRead) throws IOException {
        return IOUtil.toByteArray(in, numberOfBytesToRead, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(InputStream in, int numberOfBytesToRead, ByteOrder endian) throws IOException {
        byte[] array = new byte[numberOfBytesToRead];
        IOUtil.blockingRead(in, array, 0, numberOfBytesToRead);
        if (endian == ByteOrder.LITTLE_ENDIAN) {
            return IOUtil.switchEndian(array);
        }
        return array;
    }

    public static int computeNumberOfBitsIn(int value) {
        if (value == 0) {
            return 1;
        }
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    public static InputStream toInputStream(String input) {
        return IOUtil.toInputStream(input, UTF_8);
    }

    public static InputStream toInputStream(String input, Charset charset) {
        return new ByteArrayInputStream(input.getBytes(charset));
    }

    public static File createTempDir(String prefix, String suffix, File directory) throws IOException {
        File tmpDir;
        if (directory != null && !directory.exists()) {
            IOUtil.mkdirs(directory);
        }
        if (!(tmpDir = File.createTempFile(prefix, suffix, directory)).delete() || !tmpDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + tmpDir.getAbsolutePath());
        }
        return tmpDir;
    }

    public static void verifyIsReadable(File f) throws IOException {
        if (f == null) {
            throw new NullPointerException("file can not be null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("file must exist : " + f.getAbsolutePath());
        }
        if (!f.canRead()) {
            throw new IOException("file is not readable: " + f.getAbsolutePath());
        }
    }

    public static BufferedReader createNewBufferedReader(File file, String charset) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    public static BufferedWriter createNewBufferedWriter(File file, String charset) throws IOException {
        return IOUtil.createNewBufferedWriter(new FileOutputStream(file), charset);
    }

    public static BufferedWriter createNewBufferedWriter(OutputStream out, String charset) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(out, charset));
    }
}

