/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.internal.core.util.LIFOQueue;

public final class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private FileUtil() {
    }

    public static String createRelavitePathFrom(File root, File otherFile) throws IOException {
        return FileUtil.createRelavitePathFrom(root, otherFile, File.separatorChar);
    }

    public static String createRelavitePathFrom(File root, File otherFile, char pathSeparator) throws IOException {
        LIFOQueue<String> rootStack = FileUtil.getCanonicalStackFor(root);
        LIFOQueue<String> otherStack = FileUtil.getCanonicalStackFor(otherFile);
        while (!rootStack.isEmpty() && !otherStack.isEmpty() && ((String)rootStack.peek()).equals(otherStack.peek())) {
            rootStack.remove();
            otherStack.remove();
        }
        StringBuilder relativePath = new StringBuilder();
        while (!rootStack.isEmpty()) {
            relativePath.append("..").append(pathSeparator);
            rootStack.remove();
        }
        while (!otherStack.isEmpty()) {
            relativePath.append((String)otherStack.remove()).append(pathSeparator);
        }
        if (relativePath.length() == 0) {
            return "";
        }
        return relativePath.substring(0, relativePath.length() - 1);
    }

    private static LIFOQueue<String> getCanonicalStackFor(File f) throws IOException {
        LIFOQueue<String> stack = new LIFOQueue<String>();
        for (File currentCanonicalPath = f.getCanonicalFile(); currentCanonicalPath != null; currentCanonicalPath = currentCanonicalPath.getParentFile()) {
            stack.add(currentCanonicalPath.getName());
        }
        return stack;
    }

    private static int indexOfLastSeparator(String filename) {
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private static int indexOfExtension(String filename) {
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileUtil.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String filename = file.getName();
        return FileUtil.getExtension(filename);
    }

    public static String getExtension(String filepath) {
        if (filepath == null) {
            return null;
        }
        int extensionIndex = FileUtil.indexOfExtension(filepath);
        if (extensionIndex == -1) {
            return "";
        }
        return filepath.substring(extensionIndex + 1);
    }

    public static String getBaseName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getBaseName(file.getName());
    }

    public static String getBaseName(String filename) {
        if (filename == null) {
            return null;
        }
        int lastSeparatorIndex = FileUtil.indexOfLastSeparator(filename);
        int extensionIndex = FileUtil.indexOfExtension(filename);
        if (extensionIndex == -1) {
            return filename.substring(lastSeparatorIndex + 1);
        }
        return filename.substring(lastSeparatorIndex + 1, extensionIndex);
    }
}

