/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.io;

public final class BufferSize {
    private static int MAX_KB = 0x1FFFFF;
    private static int MAX_MB = 2047;
    private static final int CACHE_SIZE = 65;
    private static final int[] ks = new int[65];
    private static final int[] mbs = new int[65];

    private BufferSize() {
    }

    public static int kb(int size) {
        if (size < 0 || size > MAX_KB) {
            throw new IllegalArgumentException("number of kb out of range : " + size + "kb");
        }
        if (size < 65) {
            return ks[size];
        }
        return size << 10;
    }

    public static int mb(int size) {
        if (size < 0 || size > MAX_MB) {
            throw new IllegalArgumentException("number of mb out of range : " + size + "mb");
        }
        if (size < 65) {
            return mbs[size];
        }
        return size << 20;
    }

    static {
        for (int i = 1; i < 65; ++i) {
            BufferSize.ks[i] = i << 10;
            BufferSize.mbs[i] = i << 20;
        }
    }
}

