/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.datastore;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreClosedException;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;
import org.jcvi.jillion.internal.core.datastore.DataStoreStreamingIterator;
import org.jcvi.jillion.internal.core.util.Caches;
import org.jcvi.jillion.internal.core.util.Sneak;

public final class DataStoreUtil {
    private DataStoreUtil() {
    }

    public static <T> DataStore<T> adapt(Map<String, T> map) {
        return new MapDataStoreAdapter(map);
    }

    public static <T, D extends DataStore<T>> D adapt(Class<D> datastoreInterface, Map<String, T> map) {
        return DataStoreUtil.adapt(datastoreInterface, DataStore.of(map));
    }

    public static final <T, D extends DataStore<T>> D adapt(Class<D> datastoreInterface, DataStore<T> delegate) {
        return (D)((DataStore)Proxy.newProxyInstance(datastoreInterface.getClassLoader(), new Class[]{datastoreInterface}, new DataStoreInvocationHandler<T>(delegate)));
    }

    public static final <F, T, D extends DataStore<T>> D adapt(Class<D> datastoreInterface, DataStore<F> delegate, Function<F, T> callback) {
        return (D)((DataStore)Proxy.newProxyInstance(datastoreInterface.getClassLoader(), new Class[]{datastoreInterface}, new DataStoreInvocationHandler(new AdaptedDataStore<F, T>(delegate, callback))));
    }

    public static <T, D extends DataStore<T>> DataStore<T> chain(Collection<D> datastores) {
        return new WrapperDataStore(datastores);
    }

    public static <T, D extends DataStore<T>> D chain(Class<D> datastoreInterface, Collection<D> datastores) {
        WrapperDataStore wrappedDataStore = new WrapperDataStore(datastores);
        return DataStoreUtil.adapt(datastoreInterface, wrappedDataStore);
    }

    public static <D extends DataStore<?>> D createNewCachedDataStore(Class<D> c, D delegate, int cacheSize) {
        return (D)((DataStore)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c, CacheableDataStore.class}, new CachedDataStoreInvocationHandler(delegate, cacheSize, null)));
    }

    public static void clearCacheFrom(DataStore<?> cachedDataStore) {
        if (DataStoreUtil.isACachedDataStore(cachedDataStore)) {
            ((CacheableDataStore)cachedDataStore).clearCache();
        }
    }

    public static boolean isACachedDataStore(DataStore<?> cachedDataStore) {
        return cachedDataStore instanceof CacheableDataStore;
    }

    public static interface CacheableDataStore<T>
    extends DataStore<T> {
        public void clearCache();
    }

    private static final class CachedDataStoreInvocationHandler<D extends DataStore<?>>
    implements InvocationHandler {
        private final D delegate;
        private final Map<String, Object> cache;
        private static final Class<?>[] GET_PARAMETERS = new Class[]{String.class};

        private CachedDataStoreInvocationHandler(D delegate, int cacheSize) {
            this.delegate = delegate;
            this.cache = Caches.createSoftReferencedValueLRUCache(cacheSize);
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                String methodName = method.getName();
                if ("close".equals(methodName) && args == null) {
                    this.cache.clear();
                } else {
                    if ("clearCache".equals(methodName) && args == null) {
                        this.cache.clear();
                        return null;
                    }
                    if ("get".equals(methodName) && Arrays.equals(GET_PARAMETERS, method.getParameterTypes())) {
                        String id = (String)args[0];
                        Object result = this.cache.get(id);
                        if (result != null) {
                            return result;
                        }
                        Object obj = method.invoke(this.delegate, args);
                        if (obj == null) {
                            return null;
                        }
                        this.cache.put(id, obj);
                        return obj;
                    }
                }
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        /* synthetic */ CachedDataStoreInvocationHandler(DataStore x0, int x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class WrapperDataStore<T, D extends DataStore<T>>
    implements DataStore<T> {
        private final List<D> delegates;

        public WrapperDataStore(Collection<D> delegates) {
            if (delegates.isEmpty()) {
                throw new IllegalArgumentException("must be at least one DataStore");
            }
            this.delegates = new ArrayList<D>(delegates);
            for (DataStore delegate : delegates) {
                if (delegate != null) continue;
                throw new NullPointerException("DataStore can not be null");
            }
        }

        @Override
        public void close() throws IOException {
            for (DataStore delegate : this.delegates) {
                IOUtil.closeAndIgnoreErrors((Closeable)delegate);
            }
        }

        @Override
        public StreamingIterator<DataStoreEntry<T>> entryIterator() throws DataStoreException {
            ArrayList iterators = new ArrayList();
            for (DataStore delegate : this.delegates) {
                iterators.add(delegate.entryIterator());
            }
            return IteratorUtil.createChainedStreamingIterator(iterators);
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            ArrayList<StreamingIterator<String>> iterators = new ArrayList<StreamingIterator<String>>();
            for (DataStore delegate : this.delegates) {
                iterators.add(delegate.idIterator());
            }
            return IteratorUtil.createChainedStreamingIterator(iterators);
        }

        @Override
        public T get(String id) throws DataStoreException {
            if (id == null) {
                throw new NullPointerException("id can not be null");
            }
            for (DataStore delegate : this.delegates) {
                Object ret = delegate.get(id);
                if (ret == null) continue;
                return ret;
            }
            return null;
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            for (DataStore delegate : this.delegates) {
                if (!delegate.contains(id)) continue;
                return true;
            }
            return false;
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            long total = 0L;
            for (DataStore delegate : this.delegates) {
                total += delegate.getNumberOfRecords();
            }
            return total;
        }

        @Override
        public boolean isClosed() {
            for (DataStore delegate : this.delegates) {
                if (!delegate.isClosed()) continue;
                return true;
            }
            return false;
        }

        @Override
        public StreamingIterator<T> iterator() throws DataStoreException {
            ArrayList iterators = new ArrayList();
            for (DataStore delegate : this.delegates) {
                iterators.add(delegate.iterator());
            }
            return IteratorUtil.createChainedStreamingIterator(iterators);
        }
    }

    private static final class MapDataStoreAdapter<T>
    implements DataStore<T> {
        private volatile boolean isClosed;
        private final Map<String, T> map = new LinkedHashMap<String, T>();

        private MapDataStoreAdapter(Map<String, T> map) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    throw new NullPointerException("null keys not allowed");
                }
                T value = entry.getValue();
                if (value == null) {
                    throw new NullPointerException("null values not allowed");
                }
                this.map.put(key, value);
            }
        }

        @Override
        public <E extends Throwable> void forEach(ThrowingBiConsumer<String, T, E> consumer) throws IOException, E {
            this.map.forEach((? super K k, ? super V v) -> {
                try {
                    consumer.accept((String)k, (Object)v);
                }
                catch (Throwable e) {
                    Sneak.sneakyThrow(e);
                }
            });
        }

        @Override
        public ThrowingStream<T> records() throws DataStoreException {
            return ThrowingStream.asThrowingStream(this.map.values().stream());
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            if (id == null) {
                throw new NullPointerException("id can not be null");
            }
            this.throwExceptionIfClosed();
            return this.map.containsKey(id);
        }

        @Override
        public T get(String id) throws DataStoreException {
            if (id == null) {
                throw new NullPointerException("id can not be null");
            }
            this.throwExceptionIfClosed();
            return this.map.get(id);
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            this.throwExceptionIfClosed();
            return DataStoreStreamingIterator.create(this, this.map.keySet().iterator());
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            this.throwExceptionIfClosed();
            return this.map.size();
        }

        private final void throwExceptionIfClosed() {
            if (this.isClosed) {
                throw new DataStoreClosedException("DataStore is closed");
            }
        }

        @Override
        public final void close() throws IOException {
            this.isClosed = true;
        }

        @Override
        public final boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public StreamingIterator<T> iterator() {
            this.throwExceptionIfClosed();
            return DataStoreStreamingIterator.create(this, this.map.values().iterator());
        }

        @Override
        public StreamingIterator<DataStoreEntry<T>> entryIterator() throws DataStoreException {
            return IteratorUtil.createStreamingIterator(this.map.entrySet().iterator(), new IteratorUtil.TypeAdapter<Map.Entry<String, T>, DataStoreEntry<T>>(){

                @Override
                public DataStoreEntry<T> adapt(Map.Entry<String, T> from) {
                    return new DataStoreEntry(from.getKey(), from.getValue());
                }
            });
        }
    }

    private static class DataStoreInvocationHandler<T>
    implements InvocationHandler {
        private final DataStore<T> delegate;

        public DataStoreInvocationHandler(DataStore<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    private static class AdaptedDataStore<F, T>
    implements DataStore<T> {
        private final DataStore<F> delegate;
        private final Function<F, T> callback;

        public AdaptedDataStore(DataStore<F> delegate, Function<F, T> callback) {
            this.delegate = delegate;
            this.callback = callback;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public StreamingIterator<String> idIterator() throws DataStoreException {
            return this.delegate.idIterator();
        }

        @Override
        public T get(String id) throws DataStoreException {
            F original = this.delegate.get(id);
            if (original == null) {
                return null;
            }
            return this.getResultFromCallback(original);
        }

        private T getResultFromCallback(F original) {
            T ret = this.callback.apply(original);
            if (ret == null) {
                throw new NullPointerException("return value of call back can not be null");
            }
            return ret;
        }

        @Override
        public StreamingIterator<DataStoreEntry<T>> entryIterator() throws DataStoreException {
            return new StreamingIterator<DataStoreEntry<T>>(){
                StreamingIterator<DataStoreEntry<F>> delegateIterator;
                {
                    this.delegateIterator = delegate.entryIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public void close() {
                    this.delegateIterator.close();
                }

                @Override
                public DataStoreEntry<T> next() {
                    DataStoreEntry next = this.delegateIterator.next();
                    String key = next.getKey();
                    Object ret = callback.apply(next.getValue());
                    return new DataStoreEntry(key, ret);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove not supported");
                }
            };
        }

        @Override
        public boolean contains(String id) throws DataStoreException {
            return this.delegate.contains(id);
        }

        @Override
        public long getNumberOfRecords() throws DataStoreException {
            return this.delegate.getNumberOfRecords();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public StreamingIterator<T> iterator() throws DataStoreException {
            return new StreamingIterator<T>(){
                private final StreamingIterator<F> iter;
                {
                    this.iter = delegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public void close() {
                    this.iter.close();
                }

                @Override
                public T next() {
                    return this.getResultFromCallback(this.iter.next());
                }

                @Override
                public void remove() {
                    this.iter.remove();
                }
            };
        }
    }

    public static interface AdapterCallback<F, T>
    extends Function<F, T> {
        public T get(F var1);

        @Override
        default public T apply(F from) {
            return this.get(from);
        }
    }
}

