/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.datastore;

import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreFilter;

public final class DataStoreFilters {
    private DataStoreFilters() {
    }

    public static DataStoreFilter alwaysAccept() {
        return DataStoreFilterSingletons.ALWAYS_ACCEPT;
    }

    public static DataStoreFilter neverAccept() {
        return DataStoreFilterSingletons.NEVER_ACCEPT;
    }

    public static DataStoreFilter newIncludeFilter(Collection<String> ids) {
        if (ids == null) {
            throw new NullPointerException("ids can not be null");
        }
        return new IncludeDataStoreFilter(ids);
    }

    public static DataStoreFilter newExcludeFilter(Collection<String> ids) {
        if (ids == null) {
            throw new NullPointerException("ids can not be null");
        }
        return new ExcludeDataStoreFilter(ids);
    }

    public static DataStoreFilter invertFilter(DataStoreFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        return new InverseDataStoreFilter(filter);
    }

    public static DataStoreFilter newMatchFilter(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern can not be null");
        }
        return new PatternDataStoreFilter(pattern);
    }

    public static DataStoreFilter containedInDataStore(DataStore<?> datastore) {
        Objects.requireNonNull(datastore);
        return new ContainedInDataStoreFilter(datastore);
    }

    private static class PatternDataStoreFilter
    implements DataStoreFilter {
        private final Pattern pattern;

        public PatternDataStoreFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(String id) {
            Matcher matcher = this.pattern.matcher(id);
            return matcher.matches();
        }
    }

    private static enum DataStoreFilterSingletons implements DataStoreFilter
    {
        ALWAYS_ACCEPT{

            @Override
            public boolean accept(String id) {
                return true;
            }
        }
        ,
        NEVER_ACCEPT{

            @Override
            public boolean accept(String id) {
                return false;
            }
        };

    }

    private static final class InverseDataStoreFilter
    implements DataStoreFilter {
        private final DataStoreFilter filter;

        public InverseDataStoreFilter(DataStoreFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(String id) {
            return !this.filter.accept(id);
        }
    }

    private static final class ExcludeDataStoreFilter
    implements DataStoreFilter {
        private final Collection<String> ids;

        public ExcludeDataStoreFilter(Collection<String> ids) {
            this.ids = ids;
        }

        @Override
        public boolean accept(String id) {
            return !this.ids.contains(id);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.ids.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ExcludeDataStoreFilter)) {
                return false;
            }
            ExcludeDataStoreFilter other = (ExcludeDataStoreFilter)obj;
            return this.ids.equals(other.ids);
        }
    }

    private static final class IncludeDataStoreFilter
    implements DataStoreFilter {
        private final Collection<String> ids;

        public IncludeDataStoreFilter(Collection<String> ids) {
            this.ids = ids;
        }

        @Override
        public boolean accept(String id) {
            return this.ids.contains(id);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.ids.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IncludeDataStoreFilter)) {
                return false;
            }
            IncludeDataStoreFilter other = (IncludeDataStoreFilter)obj;
            return this.ids.equals(other.ids);
        }
    }

    private static final class ContainedInDataStoreFilter
    implements DataStoreFilter {
        private final DataStore<?> delegate;

        @Override
        public boolean accept(String id) {
            try {
                return this.delegate.contains(id);
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("error accessing datastore", e);
            }
        }

        public ContainedInDataStoreFilter(DataStore<?> delegate) {
            this.delegate = delegate;
        }
    }
}

