/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.datastore;

public final class DataStoreEntry<V> {
    private final String key;
    private final V value;

    public DataStoreEntry(String key, V value) {
        if (key == null) {
            throw new NullPointerException("key can not be null");
        }
        if (value == null) {
            throw new NullPointerException("value can not be null");
        }
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataStoreEntry)) {
            return false;
        }
        DataStoreEntry other = (DataStoreEntry)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        return this.value.equals(other.value);
    }
}

