/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core.datastore;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.datastore.DataStoreUtil;
import org.jcvi.jillion.core.util.ThrowingStream;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.core.util.streams.ThrowingBiConsumer;

public interface DataStore<T>
extends Closeable {
    public StreamingIterator<String> idIterator() throws DataStoreException;

    default public ThrowingStream<String> ids() throws DataStoreException {
        return this.idIterator().toThrowingStream();
    }

    public T get(String var1) throws DataStoreException;

    public boolean contains(String var1) throws DataStoreException;

    public long getNumberOfRecords() throws DataStoreException;

    public boolean isClosed();

    public StreamingIterator<T> iterator() throws DataStoreException;

    public StreamingIterator<DataStoreEntry<T>> entryIterator() throws DataStoreException;

    default public ThrowingStream<T> records() throws DataStoreException {
        return this.iterator().toThrowingStream();
    }

    default public ThrowingStream<DataStoreEntry<T>> entries() throws DataStoreException {
        return this.entryIterator().toThrowingStream();
    }

    default public <E, D extends DataStore<E>> D adapt(Class<D> datastoreInterface, Function<T, E> adapter) {
        return DataStoreUtil.adapt(datastoreInterface, this, adapter);
    }

    default public <E extends Throwable> void forEach(ThrowingBiConsumer<String, T, E> consumer) throws IOException, E {
        try (StreamingIterator<DataStoreEntry<T>> iter = this.entryIterator();){
            while (iter.hasNext()) {
                DataStoreEntry<T> entry = iter.next();
                consumer.accept(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static <T> DataStore<T> of(Map<String, T> map) {
        return DataStoreUtil.adapt(map);
    }

    public static <T, D extends DataStore<T>> D of(Map<String, T> map, Class<D> datastoreInterface) {
        return DataStoreUtil.adapt(datastoreInterface, map);
    }

    public static <D extends DataStore<?>> D cache(Class<D> c, D delegate, int cacheSize) {
        return DataStoreUtil.createNewCachedDataStore(c, delegate, cacheSize);
    }

    public static <F, T, D extends DataStore<T>> D adapt(Class<D> datastoreInterface, DataStore<F> delegate, Function<F, T> callback) {
        return DataStoreUtil.adapt(datastoreInterface, delegate, callback);
    }

    public static <T, D extends DataStore<T>> D adapt(Class<D> datastoreInterface, DataStore<T> delegate) {
        return DataStoreUtil.adapt(datastoreInterface, delegate);
    }

    public static <T, D extends DataStore<T>> DataStore<T> chain(Collection<D> datastores) {
        return DataStoreUtil.chain(datastores);
    }

    @SafeVarargs
    public static <T, D extends DataStore<T>> DataStore<T> chain(D ... datastores) {
        return DataStoreUtil.chain(Arrays.asList(datastores));
    }

    public static <T, D extends DataStore<T>> D chain(Class<D> datastoreInterface, Collection<D> datastores) {
        return DataStoreUtil.chain(datastoreInterface, datastores);
    }

    @SafeVarargs
    public static <T, D extends DataStore<T>> D chain(Class<D> datastoreInterface, D ... datastores) {
        return DataStoreUtil.chain(datastoreInterface, Arrays.asList(datastores));
    }
}

