/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.SequenceBuilder;
import org.jcvi.jillion.core.util.streams.ThrowingIndexedConsumer;

public interface Sequence<T>
extends Iterable<T> {
    public T get(long var1);

    public long getLength();

    public int hashCode();

    public boolean equals(Object var1);

    public Iterator<T> iterator(Range var1);

    default public <E extends Throwable> void forEach(Range range, ThrowingIndexedConsumer<T, E> consumer) throws E {
        Objects.requireNonNull(range);
        Objects.requireNonNull(consumer);
        Iterator<T> iter = this.iterator(range);
        long offset = range.getBegin();
        while (iter.hasNext()) {
            consumer.accept(offset++, iter.next());
        }
    }

    default public <E extends Throwable> void forEach(Range range, Consumer<T> consumer) throws E {
        Objects.requireNonNull(range);
        Objects.requireNonNull(consumer);
        Iterator<T> iter = this.iterator(range);
        while (iter.hasNext()) {
            consumer.accept(iter.next());
        }
    }

    default public <E extends Throwable> void forEach(ThrowingIndexedConsumer<T, E> consumer) throws E {
        Objects.requireNonNull(consumer);
        Iterator iter = this.iterator();
        long offset = 0L;
        while (iter.hasNext()) {
            consumer.accept(offset++, iter.next());
        }
    }

    public SequenceBuilder<T, ? extends Sequence<T>> toBuilder();

    default public String toString(Function<T, String> toStringFunction) {
        Objects.requireNonNull(toStringFunction);
        StringBuilder builder = new StringBuilder((int)this.getLength() * 3);
        for (Object aa : this) {
            String r = toStringFunction.apply(aa);
            if (r == null) continue;
            builder.append(r);
        }
        return builder.toString();
    }

    default public boolean isEmpty() {
        return this.getLength() == 0L;
    }
}

