/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.util.iter.IteratorUtil;

public final class Ranges {
    private Ranges() {
    }

    public static List<Range> merge(Collection<Range> rangesToMerge) {
        return Ranges.merge(rangesToMerge, 0);
    }

    public static List<Range> merge(Collection<Range> rangesToMerge, int maxDistanceBetweenAdjacentRanges) {
        if (maxDistanceBetweenAdjacentRanges < 0) {
            throw new IllegalArgumentException("cluster distance can not be negative");
        }
        ArrayList<Range> sortedCopy = new ArrayList<Range>(rangesToMerge);
        Collections.sort(sortedCopy, Range.Comparators.ARRIVAL);
        Ranges.mergeAnyRangesThatCanBeCombined(sortedCopy, maxDistanceBetweenAdjacentRanges);
        return sortedCopy;
    }

    public static List<Range> asRanges(BitSet bits) {
        return Ranges.asRanges(bits, 0);
    }

    public static List<Range> asRanges(BitSet bits, int maxDistance) {
        if (maxDistance < 0) {
            throw new IllegalArgumentException("maxDistance can not be negative: " + maxDistance);
        }
        if (bits.isEmpty()) {
            return Collections.emptyList();
        }
        int i = bits.nextSetBit(0);
        Range.Builder currentBuilder = new Range.Builder(i, i);
        ArrayList<Range> ret = new ArrayList<Range>();
        while (i >= 0 && i != Integer.MAX_VALUE) {
            int delta = i - (int)currentBuilder.getEnd();
            if (delta - 1 > maxDistance) {
                ret.add(currentBuilder.build());
                currentBuilder = new Range.Builder(i, i);
            } else {
                currentBuilder.expandEnd(delta);
            }
            i = bits.nextSetBit(i + 1);
        }
        ret.add(currentBuilder.build());
        return ret;
    }

    public static List<Range> asRanges(int[] sortedOffsets) {
        return Ranges.asRanges(sortedOffsets, 0);
    }

    public static List<Range> asRanges(int[] sortedOffsets, int maxDistance) {
        if (maxDistance < 0) {
            throw new IllegalArgumentException("maxDistance can not be negative: " + maxDistance);
        }
        if (sortedOffsets.length == 0) {
            return Collections.emptyList();
        }
        int lastOffset = sortedOffsets[0];
        Range.Builder currentBuilder = new Range.Builder(lastOffset, lastOffset);
        ArrayList<Range> ret = new ArrayList<Range>();
        for (int i = 1; i < sortedOffsets.length; ++i) {
            lastOffset = sortedOffsets[i];
            int delta = lastOffset - (int)currentBuilder.getEnd();
            if (delta < 0) {
                throw new IllegalArgumentException("input array must be sorted from smallest to largest");
            }
            if (delta - 1 > maxDistance) {
                ret.add(currentBuilder.build());
                currentBuilder = new Range.Builder(lastOffset, lastOffset);
                continue;
            }
            currentBuilder.expandEnd(delta);
        }
        ret.add(currentBuilder.build());
        return ret;
    }

    public static List<Range> mergeIntoClusters(Collection<Range> rangesToMerge, int maxClusterDistance) {
        List<Range> tempRanges = Ranges.merge(rangesToMerge);
        return Ranges.privateMergeRangesIntoClusters(tempRanges, maxClusterDistance);
    }

    private static List<Range> privateMergeRangesIntoClusters(List<Range> rangesToMerge, int maxClusterDistance) {
        if (maxClusterDistance < 0) {
            throw new IllegalArgumentException("max cluster distance can not be negative");
        }
        ArrayList<Range> sortedSplitCopy = new ArrayList<Range>();
        for (Range range : rangesToMerge) {
            sortedSplitCopy.addAll(range.split(maxClusterDistance));
        }
        Ranges.privateMergeAnyRangesThatCanBeClustered(sortedSplitCopy, maxClusterDistance);
        return sortedSplitCopy;
    }

    private static void privateMergeAnyRangesThatCanBeClustered(List<Range> rangesToMerge, int maxClusterDistance) {
        boolean merged;
        block0: do {
            merged = false;
            for (int i = 0; i < rangesToMerge.size() - 1; ++i) {
                Range range = rangesToMerge.get(i);
                Range nextRange = rangesToMerge.get(i + 1);
                Range combinedRange = Ranges.createInclusiveRange(range, nextRange);
                if (combinedRange.getLength() > (long)maxClusterDistance) continue;
                Ranges.replaceWithCombined(rangesToMerge, range, nextRange);
                merged = true;
                continue block0;
            }
        } while (merged);
    }

    private static void mergeAnyRangesThatCanBeCombined(List<Range> rangesToMerge, int clusterDistance) {
        boolean merged;
        block0: do {
            merged = false;
            for (int i = 0; i < rangesToMerge.size() - 1; ++i) {
                Range nextRange;
                Range range = rangesToMerge.get(i);
                Range clusteredRange = Range.of(range.getBegin() - (long)clusterDistance, range.getEnd() + (long)clusterDistance);
                if (!clusteredRange.intersects(nextRange = rangesToMerge.get(i + 1)) && !new Range.Builder(clusteredRange).shift(1L).build().intersects(nextRange)) continue;
                Ranges.replaceWithCombined(rangesToMerge, range, nextRange);
                merged = true;
                continue block0;
            }
        } while (merged);
    }

    private static void replaceWithCombined(List<Range> rangeList, Range range, Range nextRange) {
        Range combinedRange = Ranges.createInclusiveRange(range, nextRange);
        int index = rangeList.indexOf(range);
        rangeList.remove(range);
        rangeList.remove(nextRange);
        rangeList.add(index, combinedRange);
    }

    public static Range createInclusiveRange(Collection<Range> ranges) {
        return Ranges.createInclusiveRange(ranges.iterator());
    }

    private static Range createInclusiveRange(Iterator<Range> iter) {
        if (!iter.hasNext()) {
            return new Range.Builder().build();
        }
        Range firstRange = iter.next();
        long currentLeft = firstRange.getBegin();
        long currentRight = firstRange.getEnd();
        while (iter.hasNext()) {
            Range range = iter.next();
            if (range.getBegin() < currentLeft) {
                currentLeft = range.getBegin();
            }
            if (range.getEnd() <= currentRight) continue;
            currentRight = range.getEnd();
        }
        return Range.of(currentLeft, currentRight);
    }

    public static <T> Range createInclusiveRange(Collection<T> collection, Function<T, Range> mapper) {
        return Ranges.createInclusiveRange(IteratorUtil.map(collection.iterator(), mapper));
    }

    private static Range createInclusiveRange(Range ... ranges) {
        return Ranges.createInclusiveRange(Arrays.asList(ranges));
    }

    public static boolean intersects(Collection<Range> ranges, Range target) {
        for (Range r : ranges) {
            if (!r.intersects(target)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean intersects(Collection<T> ts, Function<T, Range> mapper, Range target) {
        for (T t : ts) {
            Range r = mapper.apply(t);
            if (r == null || !r.intersects(target)) continue;
            return true;
        }
        return false;
    }
}

