/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.LongConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.Ranges;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.internal.core.util.Caches;
import org.jcvi.jillion.internal.core.util.JillionUtil;

public abstract class Range
implements Rangeable,
Iterable<Long>,
Serializable {
    private static final long serialVersionUID = -4383105989868994198L;
    private static final int UNSIGNED_BYTE_MAX = 255;
    private static final int UNSIGNED_SHORT_MAX = 65535;
    private static final long UNSIGNED_INT_MAX = 0xFFFFFFFFL;
    private static final int INITIAL_CACHE_SIZE = 1024;
    private static Pattern DOT_PATTERN = Pattern.compile("(\\d+)\\s*\\.\\.\\s*(\\d+)");
    private static Pattern DASH_PATTERN = Pattern.compile("(\\d+)\\s*-\\s*(\\d+)");
    private static Pattern COMMA_PATTERN = Pattern.compile("(\\d+)\\s*,\\s*(\\d+)");
    private static final Map<CacheKey, Range> CACHE = Caches.createSoftReferencedValueCache(1024);

    public static Range of(long start, long end) {
        return new Builder(start, end).build();
    }

    public static Range of(long singleCoordinate) {
        return new Builder(1L).shift(singleCoordinate).build();
    }

    public static Range of(CoordinateSystem coordinateSystem, long singleCoordinate) {
        return new Builder(1L).shift(coordinateSystem.getStart(singleCoordinate)).build();
    }

    public static Range of(CoordinateSystem coordinateSystem, long localStart, long localEnd) {
        return new Builder(coordinateSystem, localStart, localEnd).build();
    }

    private static Range buildNewRange(long zeroBasedStart, long zeroBasedEnd) {
        if (zeroBasedStart >= 0L) {
            long length = zeroBasedEnd - zeroBasedStart + 1L;
            return Range.buildNewUnsignedRange(zeroBasedStart, zeroBasedEnd, length);
        }
        return Range.buildNewSignedRange(zeroBasedStart, zeroBasedEnd);
    }

    private static Range buildNewSignedRange(long zeroBasedStart, long zeroBasedEnd) {
        if (Range.canFitInSignedByte(zeroBasedStart, zeroBasedEnd)) {
            return new ByteRange((byte)zeroBasedStart, (byte)zeroBasedEnd);
        }
        if (Range.canFitInSignedShort(zeroBasedStart, zeroBasedEnd)) {
            return new ShortRange((short)zeroBasedStart, (short)zeroBasedEnd);
        }
        if (Range.canFitInSignedInt(zeroBasedStart, zeroBasedEnd)) {
            return new IntRange((int)zeroBasedStart, (int)zeroBasedEnd);
        }
        return new LongRange(zeroBasedStart, zeroBasedEnd);
    }

    private static boolean canFitInSignedByte(long start, long end) {
        return start <= 127L && start >= -128L && end <= 127L && end >= -128L;
    }

    private static boolean canFitInSignedShort(long start, long end) {
        return start <= 32767L && start >= -32768L && end <= 32767L && end >= -32768L;
    }

    private static boolean canFitInSignedInt(long start, long end) {
        return start <= Integer.MAX_VALUE && start >= Integer.MIN_VALUE && end <= Integer.MAX_VALUE && end >= Integer.MIN_VALUE;
    }

    private static Range buildNewUnsignedRange(long zeroBasedStart, long zeroBasedEnd, long length) {
        if (zeroBasedStart <= 255L) {
            if (length <= 65535L) {
                return new UnsignedByteStartShortLengthRange((short)zeroBasedStart, (int)length);
            }
            if (length <= 0xFFFFFFFFL) {
                return new UnsignedByteStartIntLengthRange((short)zeroBasedStart, length);
            }
            return new UnsignedByteStartLongLengthRange((short)zeroBasedStart, length);
        }
        if (zeroBasedStart <= 65535L) {
            if (length <= 65535L) {
                return new UnsignedShortStartShortLengthRange((int)zeroBasedStart, (int)length);
            }
            if (length <= 0xFFFFFFFFL) {
                return new UnsignedShortStartIntLengthRange((int)zeroBasedStart, length);
            }
            return new UnsignedShortStartLongLengthRange((int)zeroBasedStart, length);
        }
        if (zeroBasedStart <= 0xFFFFFFFFL) {
            if (length <= 0xFFFFFFFFL) {
                return new UnsignedIntStartIntLengthRange(zeroBasedStart, length);
            }
            return new UnsignedIntStartLongLengthRange(zeroBasedStart, length);
        }
        if (length <= 0xFFFFFFFFL) {
            return new LongStartIntLengthRange(zeroBasedStart, length);
        }
        return new LongRange(zeroBasedStart, zeroBasedEnd);
    }

    private static Range buildNewEmptyRange(long zeroBasedStart) {
        long absValue = Math.abs(zeroBasedStart);
        if (absValue <= 127L) {
            return new EmptyByteRange((byte)zeroBasedStart);
        }
        if (absValue <= 32767L) {
            return new EmptyShortRange((short)zeroBasedStart);
        }
        if (absValue <= Integer.MAX_VALUE) {
            return new EmptyIntRange((int)zeroBasedStart);
        }
        return new EmptyLongRange(zeroBasedStart);
    }

    static synchronized Range removeFromCache(Range range) {
        CacheKey key = CacheKey.createCacheKeyFor(range);
        if (key != null) {
            return CACHE.remove(key);
        }
        return null;
    }

    public static Range ofLength(long length) {
        return new Builder(length).build();
    }

    public static Range parseRange(String rangeAsString, CoordinateSystem coordinateSystem) {
        Matcher dotMatcher = DOT_PATTERN.matcher(rangeAsString);
        if (dotMatcher.find()) {
            return Range.convertIntoRange(dotMatcher, coordinateSystem);
        }
        Matcher dashMatcher = DASH_PATTERN.matcher(rangeAsString);
        if (dashMatcher.find()) {
            return Range.convertIntoRange(dashMatcher, coordinateSystem);
        }
        Matcher commaMatcher = COMMA_PATTERN.matcher(rangeAsString);
        if (commaMatcher.find()) {
            return Range.convertIntoRange(commaMatcher, coordinateSystem);
        }
        throw new IllegalArgumentException("can not parse " + rangeAsString + " into a Range");
    }

    public static Range parseRange(String rangeAsString) {
        return Range.parseRange(rangeAsString, CoordinateSystem.ZERO_BASED);
    }

    private static Range convertIntoRange(Matcher dashMatcher, CoordinateSystem coordinateSystem) {
        return Range.of(coordinateSystem, Long.parseLong(dashMatcher.group(1)), Long.parseLong(dashMatcher.group(2)));
    }

    private Range() {
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public abstract long getBegin();

    public long getBegin(CoordinateSystem coordinateSystem) {
        if (coordinateSystem == null) {
            throw new NullPointerException("CoordinateSystem can not be null");
        }
        return coordinateSystem.getLocalStart(this.getBegin());
    }

    @Override
    public abstract long getEnd();

    public long getEnd(CoordinateSystem coordinateSystem) {
        if (coordinateSystem == null) {
            throw new NullPointerException("CoordinateSystem can not be null");
        }
        return coordinateSystem.getLocalEnd(this.getEnd());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean isSubRangeOf(Range range) {
        if (range == null) {
            throw new NullPointerException("range can not be null");
        }
        return this.getBegin() >= range.getBegin() && this.getEnd() <= range.getEnd();
    }

    @Override
    public boolean intersects(Rangeable target) {
        if (target instanceof Range) {
            return this.intersects((Range)target);
        }
        return Rangeable.super.intersects(target);
    }

    public boolean intersects(Range target) {
        if (target == null) {
            throw new NullPointerException("Null Range used in intersection operation.");
        }
        if (this.isEmpty()) {
            return false;
        }
        if (target.isEmpty()) {
            return target.intersects(this);
        }
        return this.getBegin() <= target.getEnd() && this.getEnd() >= target.getBegin();
    }

    public Range intersection(Range other) {
        if (other == null) {
            throw new IllegalArgumentException("Null Range used in intersection operation.");
        }
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        long intersectionStart = Math.max(other.getBegin(), this.getBegin());
        long intersectionEnd = Math.min(other.getEnd(), this.getEnd());
        long length = intersectionEnd - intersectionStart + 1L;
        if (length <= -1L) {
            return new Builder().build();
        }
        return new Builder(length).shift(intersectionStart).build();
    }

    public List<Range> complement(Range other) {
        Range afterOther;
        Range beforeOther;
        Range intersection = this.intersection(other);
        if (intersection.isEmpty()) {
            return Collections.singletonList(this);
        }
        ArrayList<Range> complementedRanges = new ArrayList<Range>();
        if (intersection.getBegin() != Long.MIN_VALUE && !(beforeOther = Range.of(this.getBegin(), intersection.getBegin() - 1L)).isEmpty()) {
            complementedRanges.add(beforeOther);
        }
        if (intersection.getEnd() != Long.MAX_VALUE && !(afterOther = Range.of(intersection.getEnd() + 1L, this.getEnd())).isEmpty()) {
            complementedRanges.add(afterOther);
        }
        return Ranges.merge(complementedRanges);
    }

    public List<Range> complement(Collection<Range> others) {
        List<Range> completeExonRange;
        List<Range> exons = Ranges.merge(others);
        if (exons.isEmpty()) {
            return Collections.singletonList(this);
        }
        List<Range> introns = completeExonRange = Collections.singletonList(this);
        for (Range exon : exons) {
            introns = exon.complementFrom(introns);
        }
        return introns.equals(completeExonRange) ? Collections.emptyList() : introns;
    }

    List<Range> complementFrom(Collection<Range> ranges) {
        List<Range> universe = Ranges.merge(new ArrayList<Range>(ranges));
        ArrayList<Range> complements = new ArrayList<Range>(universe.size());
        for (Range range : universe) {
            complements.addAll(range.complement(this));
        }
        return Ranges.merge(complements);
    }

    public boolean startsBefore(Range other) {
        if (other == null) {
            throw new NullPointerException("Null Range used in range comparison operation.");
        }
        return this.getBegin() < other.getBegin();
    }

    public boolean endsBefore(Range other) {
        if (other == null) {
            throw new NullPointerException("Null Range used in range comparison operation.");
        }
        return this.getEnd() < other.getBegin();
    }

    public String toString() {
        return this.toString(CoordinateSystem.ZERO_BASED);
    }

    public String toString(CoordinateSystem coordinateSystem) {
        return this.toString((long b, long e, CoordinateSystem cs) -> "[ " + b + " .. " + e + " ]/" + cs.getAbbreviatedName(), coordinateSystem);
    }

    public String toString(RangeToStringFunction function) {
        return this.toString(function, CoordinateSystem.ZERO_BASED);
    }

    public String toString(RangeToStringFunction function, CoordinateSystem coordinateSystem) {
        Objects.requireNonNull(coordinateSystem);
        return function.apply(coordinateSystem.getLocalStart(this.getBegin()), coordinateSystem.getLocalEnd(this.getEnd()));
    }

    public String toString(RangeAndCoordinateSystemToStringFunction function) {
        return this.toString(function, CoordinateSystem.ZERO_BASED);
    }

    public String toString(RangeAndCoordinateSystemToStringFunction function, CoordinateSystem coordinateSystem) {
        Objects.requireNonNull(coordinateSystem);
        return function.apply(coordinateSystem.getLocalStart(this.getBegin()), coordinateSystem.getLocalEnd(this.getEnd()), coordinateSystem);
    }

    @Override
    public Iterator<Long> iterator() {
        return new RangeIterator(this);
    }

    public List<Range> split(long maxSplitLength) {
        if (maxSplitLength < 1L) {
            throw new IllegalArgumentException("max splitLength must be >= 1");
        }
        ArrayList<Range> list = new ArrayList<Range>();
        if (this.getLength() < maxSplitLength) {
            list.add(this);
        } else {
            long end = this.getEnd();
            for (long currentStart = this.getBegin(); currentStart <= end; currentStart += maxSplitLength) {
                long endCoordinate = Math.min(end, currentStart + maxSplitLength - 1L);
                list.add(Range.of(currentStart, endCoordinate));
            }
        }
        return list;
    }

    public void forEachValue(CoordinateSystem cs, LongConsumer consumer) {
        Objects.requireNonNull(cs);
        Objects.requireNonNull(consumer);
        long begin = this.getBegin(cs);
        long end = this.getEnd(cs);
        for (long l = begin; l <= end; ++l) {
            consumer.accept(l);
        }
    }

    public void forEachValue(LongConsumer consumer) {
        this.forEachValue(CoordinateSystem.ZERO_BASED, consumer);
    }

    @Override
    public long getLength() {
        return this.getEnd() - this.getBegin() + 1L;
    }

    @Override
    public Range asRange() {
        return this;
    }

    protected Object writeReplace() {
        return new RangeProxy(this);
    }

    protected void readObjectTemplate(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private static final class CacheKey {
        private final int begin;
        private final int end;

        public CacheKey(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public static CacheKey createCacheKeyFor(Range range) {
            return CacheKey.createCacheKeyFor(range.getBegin(), range.getEnd());
        }

        public static CacheKey createCacheKeyFor(long begin, long end) {
            if (begin < 0L || begin > Integer.MAX_VALUE || end < 0L || end > Integer.MAX_VALUE) {
                return null;
            }
            return new CacheKey((int)begin, (int)end);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.begin;
            result = 31 * result + this.end;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.begin != other.begin) {
                return false;
            }
            return this.end == other.end;
        }
    }

    public static final class Builder
    implements Rangeable {
        private long begin;
        private long end;
        private final CoordinateSystem inputCoordinateSystem;

        public Builder() {
            this(0L);
        }

        public Builder(Builder copy) {
            this(copy.inputCoordinateSystem, copy.begin, copy.end);
        }

        public Builder(long begin, long end) {
            this(CoordinateSystem.ZERO_BASED, begin, end);
        }

        public Builder(CoordinateSystem cs, long begin, long end) {
            if (cs == null) {
                throw new NullPointerException("CoordinateSystem can not be null");
            }
            this.assertValidCoordinates(begin, end);
            this.begin = cs.getStart(begin);
            this.end = cs.getEnd(end);
            this.inputCoordinateSystem = cs;
        }

        private void assertValidCoordinates(long begin, long end) {
            long length = end - begin + 1L;
            if (length < 0L) {
                throw new IllegalArgumentException("length can not be negative");
            }
        }

        public Builder(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("must be >=0");
            }
            this.begin = 0L;
            this.end = length - 1L;
            this.inputCoordinateSystem = CoordinateSystem.ZERO_BASED;
        }

        public Builder(Range range) {
            if (range == null) {
                throw new NullPointerException("range can not be null");
            }
            this.begin = range.getBegin();
            this.end = range.getEnd();
            this.inputCoordinateSystem = CoordinateSystem.ZERO_BASED;
        }

        public Builder shift(long units) {
            this.begin += units;
            this.end += units;
            return this;
        }

        public Builder contractBegin(long units) {
            long newBegin = this.begin + units;
            this.assertValidCoordinates(newBegin, this.end);
            this.begin = newBegin;
            return this;
        }

        public Builder contractEnd(long units) {
            long newEnd = this.end - units;
            this.assertValidCoordinates(this.begin, newEnd);
            this.end -= units;
            return this;
        }

        public Builder expandBegin(long units) {
            this.begin -= units;
            return this;
        }

        public Builder expandEnd(long units) {
            this.end += units;
            return this;
        }

        @Override
        public long getBegin() {
            return this.begin;
        }

        public Builder setBegin(long begin) {
            this.begin = begin;
            return this;
        }

        @Override
        public long getEnd() {
            return this.end;
        }

        public Builder setEnd(long end) {
            this.end = end;
            return this;
        }

        @Override
        public long getLength() {
            return this.end - this.begin + 1L;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Range build() {
            long maxLength;
            long length = this.end - this.begin + 1L;
            if (length < 0L) {
                throw new IllegalArgumentException("length can not be negative");
            }
            if (this.begin > 0L && (maxLength = Long.MAX_VALUE - this.begin + 1L) < length) {
                throw new IndexOutOfBoundsException(String.format("given length %d would make range [%d - ? ] beyond max allowed end offset", this.end, this.begin));
            }
            CacheKey cacheKey = CacheKey.createCacheKeyFor(this.begin, this.end);
            if (cacheKey != null) {
                return CACHE.computeIfAbsent(cacheKey, k -> {
                    if (((CacheKey)k).end >= ((CacheKey)k).begin) {
                        return Range.buildNewRange(((CacheKey)k).begin, ((CacheKey)k).end);
                    }
                    return Range.buildNewEmptyRange(((CacheKey)k).begin);
                });
            }
            if (this.end >= this.begin) {
                return Range.buildNewRange(this.begin, this.end);
            }
            return Range.buildNewEmptyRange(this.begin);
        }

        public String toString() {
            return "Builder [begin=" + this.begin + ", end=" + this.end + ", inputCoordinateSystem=" + (Object)((Object)this.inputCoordinateSystem) + "]";
        }

        public Builder intersect(Range other) {
            LongRange temp = new LongRange(this.begin, this.end);
            Range result = temp.intersection(other);
            this.begin = result.getBegin();
            this.end = result.getEnd();
            return this;
        }

        public Builder intersect(Builder other) {
            return this.intersect(other.asRange());
        }

        @Override
        public Range asRange() {
            return new LongRange(this.begin, this.end);
        }

        @Override
        public boolean isEmpty() {
            return this.end - this.begin < 0L;
        }

        public boolean startsAfter(Range other) {
            return this.begin > other.getEnd();
        }

        public boolean startsBefore(Range other) {
            return this.begin < other.getBegin();
        }

        public boolean endsAfter(Range other) {
            return this.end > other.getEnd();
        }

        public boolean endsBefore(Range other) {
            return this.end > other.getBegin();
        }
    }

    private static final class EmptyLongRange
    extends Range {
        private static final long serialVersionUID = -5311954556848083143L;
        private final transient long coordinate;

        EmptyLongRange(long coordinate) {
            this.coordinate = coordinate;
        }

        @Override
        public long getBegin() {
            return this.coordinate;
        }

        @Override
        public long getEnd() {
            return this.coordinate - 1L;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.coordinate ^ this.coordinate >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyLongRange other = (EmptyLongRange)obj;
            return this.coordinate == other.coordinate;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class EmptyIntRange
    extends Range {
        private static final long serialVersionUID = -2154880669709555228L;
        private final transient int coordinate;

        EmptyIntRange(int coordinate) {
            this.coordinate = coordinate;
        }

        @Override
        public long getBegin() {
            return this.coordinate;
        }

        @Override
        public long getEnd() {
            return this.coordinate - 1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.coordinate;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyIntRange other = (EmptyIntRange)obj;
            return this.coordinate == other.coordinate;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class EmptyShortRange
    extends Range {
        private static final long serialVersionUID = 3993935906380566318L;
        private final transient short coordinate;

        EmptyShortRange(short coordinate) {
            this.coordinate = coordinate;
        }

        @Override
        public long getBegin() {
            return this.coordinate;
        }

        @Override
        public long getEnd() {
            return this.coordinate - 1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.coordinate;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyShortRange other = (EmptyShortRange)obj;
            return this.coordinate == other.coordinate;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class EmptyByteRange
    extends Range {
        private static final long serialVersionUID = 6052661929330419290L;
        private final transient byte coordinate;

        EmptyByteRange(byte coordinate) {
            this.coordinate = coordinate;
        }

        @Override
        public long getBegin() {
            return this.coordinate;
        }

        @Override
        public long getEnd() {
            return this.coordinate - 1;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.coordinate;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EmptyByteRange other = (EmptyByteRange)obj;
            return this.coordinate == other.coordinate;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class LongStartIntLengthRange
    extends Range {
        private static final long serialVersionUID = -8753338879553066878L;
        private final transient long start;
        private final transient int length;

        private LongStartIntLengthRange(long start, long length) {
            this.start = start;
            this.length = IOUtil.toSignedInt(length);
        }

        @Override
        public long getLength() {
            return IOUtil.toUnsignedInt(this.length);
        }

        @Override
        public long getBegin() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LongStartIntLengthRange other = (LongStartIntLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedIntStartLongLengthRange
    extends Range {
        private static final long serialVersionUID = -117640702327997461L;
        private final transient int start;
        private final transient long length;

        private UnsignedIntStartLongLengthRange(long start, long length) {
            this.start = IOUtil.toSignedInt(start);
            this.length = length;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedInt(this.start);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedIntStartLongLengthRange other = (UnsignedIntStartLongLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedIntStartIntLengthRange
    extends Range {
        private static final long serialVersionUID = 6452717883182530834L;
        private final transient int start;
        private final transient int length;

        private UnsignedIntStartIntLengthRange(long start, long length) {
            this.start = IOUtil.toSignedInt(start);
            this.length = IOUtil.toSignedInt(length);
        }

        @Override
        public long getLength() {
            return IOUtil.toUnsignedInt(this.length);
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedInt(this.start);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedIntStartIntLengthRange other = (UnsignedIntStartIntLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedShortStartLongLengthRange
    extends Range {
        private static final long serialVersionUID = -1165486112049464271L;
        private final transient short start;
        private final transient long length;

        private UnsignedShortStartLongLengthRange(int start, long length) {
            this.start = IOUtil.toSignedShort(start);
            this.length = length;
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedShort(this.start);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedShortStartLongLengthRange other = (UnsignedShortStartLongLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedShortStartIntLengthRange
    extends Range {
        private static final long serialVersionUID = -7100338012680013390L;
        private final transient int length;
        private final transient short start;

        private UnsignedShortStartIntLengthRange(int start, long length) {
            this.start = IOUtil.toSignedShort(start);
            this.length = IOUtil.toSignedInt(length);
        }

        @Override
        public long getLength() {
            return IOUtil.toUnsignedInt(this.length);
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedShort(this.start);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedShortStartIntLengthRange other = (UnsignedShortStartIntLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedShortStartShortLengthRange
    extends Range {
        private static final long serialVersionUID = -3396601756878334868L;
        private final transient short start;
        private final transient short length;

        private UnsignedShortStartShortLengthRange(int start, int length) {
            this.start = IOUtil.toSignedShort(start);
            this.length = IOUtil.toSignedShort(length);
        }

        @Override
        public long getLength() {
            return IOUtil.toUnsignedShort(this.length);
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedShort(this.start);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedShortStartShortLengthRange other = (UnsignedShortStartShortLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedByteStartLongLengthRange
    extends Range {
        private static final long serialVersionUID = 7162925703817321503L;
        private final transient byte start;
        private final transient long length;

        private UnsignedByteStartLongLengthRange(short start, long length) {
            this.start = IOUtil.toSignedByte(start);
            this.length = length;
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedByte(this.start);
        }

        @Override
        public long getLength() {
            return this.length;
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.length ^ this.length >>> 32);
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedByteStartLongLengthRange other = (UnsignedByteStartLongLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedByteStartIntLengthRange
    extends Range {
        private static final long serialVersionUID = -8157832996658862640L;
        private final transient byte start;
        private final transient int length;

        private UnsignedByteStartIntLengthRange(short start, long length) {
            this.start = IOUtil.toSignedByte(start);
            this.length = IOUtil.toSignedInt(length);
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedByte(this.start);
        }

        @Override
        public long getLength() {
            return IOUtil.toUnsignedInt(this.length);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedByteStartIntLengthRange other = (UnsignedByteStartIntLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class UnsignedByteStartShortLengthRange
    extends Range {
        private static final long serialVersionUID = 8988060061626955851L;
        private final transient byte start;
        private final transient short length;

        private UnsignedByteStartShortLengthRange(short start, int length) {
            this.start = IOUtil.toSignedByte(start);
            this.length = IOUtil.toSignedShort(length);
        }

        @Override
        public long getBegin() {
            return IOUtil.toUnsignedByte(this.start);
        }

        @Override
        public long getLength() {
            return IOUtil.toUnsignedShort(this.length);
        }

        @Override
        public long getEnd() {
            return this.getBegin() + this.getLength() - 1L;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnsignedByteStartShortLengthRange other = (UnsignedByteStartShortLengthRange)obj;
            if (this.length != other.length) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class ByteRange
    extends Range {
        private static final long serialVersionUID = 4169626247473789826L;
        private final transient byte start;
        private final transient byte end;

        private ByteRange(byte start, byte end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public long getBegin() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.end;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ByteRange other = (ByteRange)obj;
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class ShortRange
    extends Range {
        private static final long serialVersionUID = 8067459912024393712L;
        private final transient short start;
        private final transient short end;

        private ShortRange(short start, short end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public long getBegin() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.end;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ShortRange other = (ShortRange)obj;
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class IntRange
    extends Range {
        private static final long serialVersionUID = 6542145038027107374L;
        private final transient int start;
        private final transient int end;

        private IntRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public long getBegin() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.end;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.end;
            result = 31 * result + this.start;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntRange other = (IntRange)obj;
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static final class LongRange
    extends Range {
        private static final long serialVersionUID = -9049228665266839643L;
        private final transient long start;
        private final transient long end;

        private LongRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public long getBegin() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.end;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.end ^ this.end >>> 32);
            result = 31 * result + (int)(this.start ^ this.start >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LongRange other = (LongRange)obj;
            if (this.end != other.end) {
                return false;
            }
            return this.start == other.start;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            this.readObjectTemplate(stream);
        }
    }

    private static class RangeIterator
    implements Iterator<Long> {
        private final long from;
        private final long to;
        private long index;

        public RangeIterator(Range range) {
            this.from = range.getBegin();
            this.to = range.getEnd();
            this.index = this.from;
        }

        @Override
        public boolean hasNext() {
            if (this.to == Long.MAX_VALUE) {
                return this.index >= this.from && this.index != this.to;
            }
            return this.index <= this.to;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.index++;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can not remove from Range");
        }
    }

    private static final class RangeProxy
    implements Serializable {
        private static final long serialVersionUID = -4585616544869644009L;
        private final long begin;
        private final long end;

        RangeProxy(Range range) {
            this.begin = range.getBegin();
            this.end = range.getEnd();
        }

        private Object readResolve() {
            return Range.of(this.begin, this.end);
        }
    }

    @FunctionalInterface
    public static interface RangeAndCoordinateSystemToStringFunction {
        public String apply(long var1, long var3, CoordinateSystem var5);
    }

    @FunctionalInterface
    static interface RangeToStringFunction {
        public String apply(long var1, long var3);
    }

    public static enum CoordinateSystem {
        ZERO_BASED("Zero Based", "0B", 0L, 0L, 0L, 0L),
        RESIDUE_BASED("Residue Based", "RB", 1L, 1L, -1L, -1L),
        SPACE_BASED("Space Based", "SB", 0L, 1L, 0L, -1L);

        private String displayName;
        private String abbreviatedName;
        private long zeroBaseToCoordinateSystemStartAdjustmentValue;
        private long zeroBaseToCoordinateSystemEndAdjustmentValue;
        private long coordinateSystemToZeroBaseStartAdjustmentValue;
        private long coordinateSystemToZeroBaseEndAdjustmentValue;

        private CoordinateSystem(String displayName, String abbreviatedName, long zeroBaseToCoordinateSystemStartAdjustmentValue, long zeroBaseToCoordinateSystemEndAdjustmentValue, long coordinateSystemToZeroBaseStartAdjustmentValue, long coordinateSystemToZeroBaseEndAdjustmentValue) {
            this.displayName = displayName;
            this.abbreviatedName = abbreviatedName;
            this.zeroBaseToCoordinateSystemStartAdjustmentValue = zeroBaseToCoordinateSystemStartAdjustmentValue;
            this.zeroBaseToCoordinateSystemEndAdjustmentValue = zeroBaseToCoordinateSystemEndAdjustmentValue;
            this.coordinateSystemToZeroBaseStartAdjustmentValue = coordinateSystemToZeroBaseStartAdjustmentValue;
            this.coordinateSystemToZeroBaseEndAdjustmentValue = coordinateSystemToZeroBaseEndAdjustmentValue;
        }

        public String getAbbreviatedName() {
            return this.abbreviatedName;
        }

        public String toString() {
            return this.displayName;
        }

        private long getLocalStart(long zeroBasedStart) {
            return zeroBasedStart + this.zeroBaseToCoordinateSystemStartAdjustmentValue;
        }

        private long getLocalEnd(long zeroBasedEnd) {
            return zeroBasedEnd + this.zeroBaseToCoordinateSystemEndAdjustmentValue;
        }

        private long getStart(long localStart) {
            return localStart + this.coordinateSystemToZeroBaseStartAdjustmentValue;
        }

        private long getEnd(long localEnd) {
            return localEnd + this.coordinateSystemToZeroBaseEndAdjustmentValue;
        }
    }

    public static enum Comparators implements Comparator<Range>
    {
        ARRIVAL{

            @Override
            public int compare(Range first, Range second) {
                if (first == null) {
                    throw new NullPointerException("The first parameter in the comparison is null.");
                }
                if (second == null) {
                    throw new NullPointerException("The second parameter in the comparison is null.");
                }
                int startComparison = JillionUtil.compare(first.getBegin(), second.getBegin());
                if (startComparison == 0) {
                    return JillionUtil.compare(first.getEnd(), second.getEnd());
                }
                return startComparison;
            }
        }
        ,
        DEPARTURE{

            @Override
            public int compare(Range first, Range second) {
                if (first == null) {
                    throw new NullPointerException("The first parameter in the comparison is null.");
                }
                if (second == null) {
                    throw new NullPointerException("The second parameter in the comparison is null.");
                }
                int endComparison = JillionUtil.compare(first.getEnd(), second.getEnd());
                if (endComparison == 0) {
                    return JillionUtil.compare(first.getBegin(), second.getBegin());
                }
                return endComparison;
            }
        }
        ,
        LONGEST_TO_SHORTEST{

            @Override
            public int compare(Range o1, Range o2) {
                return -1 * JillionUtil.compare(o1.getLength(), o2.getLength());
            }
        }
        ,
        SHORTEST_TO_LONGEST{

            @Override
            public int compare(Range o1, Range o2) {
                return JillionUtil.compare(o1.getLength(), o2.getLength());
            }
        };

    }
}

