/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core;

import java.util.HashMap;
import java.util.Map;

public enum Direction {
    FORWARD,
    REVERSE;

    private static Map<String, Direction> PARSED_DIRECTIONS;

    public static Direction parseSequenceDirection(String dirString) {
        if (dirString == null) {
            throw new NullPointerException("dirString can not be null");
        }
        if (PARSED_DIRECTIONS.containsKey(dirString)) {
            return PARSED_DIRECTIONS.get(dirString);
        }
        String firstLetter = dirString.trim().substring(0, 1);
        if (PARSED_DIRECTIONS.containsKey(firstLetter)) {
            return PARSED_DIRECTIONS.get(firstLetter);
        }
        throw new IllegalArgumentException("unknown dirString : " + dirString);
    }

    public String getCode() {
        return Character.toString(this.getCodeCharacter());
    }

    public char getCodeCharacter() {
        return this.name().charAt(0);
    }

    public Direction oppositeOrientation() {
        if (this == FORWARD) {
            return REVERSE;
        }
        if (this == REVERSE) {
            return FORWARD;
        }
        return this;
    }

    static {
        PARSED_DIRECTIONS = new HashMap<String, Direction>();
        PARSED_DIRECTIONS.put("-", REVERSE);
        PARSED_DIRECTIONS.put("R", REVERSE);
        PARSED_DIRECTIONS.put("r", REVERSE);
        PARSED_DIRECTIONS.put("TR", REVERSE);
        PARSED_DIRECTIONS.put("Tr", REVERSE);
        PARSED_DIRECTIONS.put("tr", REVERSE);
        PARSED_DIRECTIONS.put("tR", REVERSE);
        PARSED_DIRECTIONS.put("1", REVERSE);
        PARSED_DIRECTIONS.put("+", FORWARD);
        PARSED_DIRECTIONS.put("F", FORWARD);
        PARSED_DIRECTIONS.put("f", FORWARD);
        PARSED_DIRECTIONS.put("TF", FORWARD);
        PARSED_DIRECTIONS.put("Tf", FORWARD);
        PARSED_DIRECTIONS.put("tF", FORWARD);
        PARSED_DIRECTIONS.put("tf", FORWARD);
        PARSED_DIRECTIONS.put("0", FORWARD);
    }
}

