/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.core;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Rangeable;

public final class DirectedRange
implements Rangeable,
Serializable {
    private static final long serialVersionUID = 6483275803274837762L;
    private static Pattern DOT_PATTERN = Pattern.compile("(-?\\d+)\\s*\\.\\.\\s*(-?\\d+)");
    private static Pattern DASH_PATTERN = Pattern.compile("(-?\\d+)\\s*-\\s*(-?\\d+)");
    private static Pattern COMMA_PATTERN = Pattern.compile("(-?\\d+)\\s*,\\s*(-?\\d+)");
    private final Range range;
    private final Direction direction;

    public static DirectedRange parse(String rangeAsString, Range.CoordinateSystem coordinateSystem) {
        Matcher dotMatcher = DOT_PATTERN.matcher(rangeAsString);
        if (dotMatcher.find()) {
            return DirectedRange.convertIntoRange(dotMatcher, coordinateSystem);
        }
        Matcher dashMatcher = DASH_PATTERN.matcher(rangeAsString);
        if (dashMatcher.find()) {
            return DirectedRange.convertIntoRange(dashMatcher, coordinateSystem);
        }
        Matcher commaMatcher = COMMA_PATTERN.matcher(rangeAsString);
        if (commaMatcher.find()) {
            return DirectedRange.convertIntoRange(commaMatcher, coordinateSystem);
        }
        throw new IllegalArgumentException("can not parse " + rangeAsString + " into a Range");
    }

    public static DirectedRange create(Range range) {
        return DirectedRange.create(range, Direction.FORWARD);
    }

    public static DirectedRange create(Range range, Direction direction) {
        return new DirectedRange(range, direction);
    }

    public static DirectedRange of(long start, long end, Direction direction) {
        return DirectedRange.create(Range.of(start, end), direction);
    }

    private static DirectedRange convertIntoRange(Matcher dashMatcher, Range.CoordinateSystem coordinateSystem) {
        long first = Long.parseLong(dashMatcher.group(1));
        long second = Long.parseLong(dashMatcher.group(2));
        return DirectedRange.convertIntoRange(coordinateSystem, first, second);
    }

    private static DirectedRange convertIntoRange(Range.CoordinateSystem coordinateSystem, long first, long second) {
        if (first < second) {
            Range range = Range.of(coordinateSystem, first, second);
            return new DirectedRange(range, Direction.FORWARD);
        }
        Range range = Range.of(coordinateSystem, second, first);
        return new DirectedRange(range, Direction.REVERSE);
    }

    public static DirectedRange parse(String rangeAsString) {
        return DirectedRange.parse(rangeAsString, Range.CoordinateSystem.ZERO_BASED);
    }

    public static DirectedRange parse(long firstCoord, long secondCoord) {
        return DirectedRange.convertIntoRange(Range.CoordinateSystem.ZERO_BASED, firstCoord, secondCoord);
    }

    public static DirectedRange parse(long firstCoord, long secondCoord, Range.CoordinateSystem coordinateSystem) {
        return DirectedRange.convertIntoRange(coordinateSystem, firstCoord, secondCoord);
    }

    public static DirectedRange parse(String firstCoord, String secondCoord) {
        return DirectedRange.parse(firstCoord, secondCoord, Range.CoordinateSystem.ZERO_BASED);
    }

    public static DirectedRange parse(String firstCoord, String secondCoord, Range.CoordinateSystem coordinateSystem) {
        long first = Long.parseLong(firstCoord);
        long second = Long.parseLong(secondCoord);
        return DirectedRange.convertIntoRange(coordinateSystem, first, second);
    }

    private DirectedRange(Range range, Direction direction) {
        if (range == null) {
            throw new NullPointerException("range can not be null");
        }
        if (direction == null) {
            throw new NullPointerException("direction can not be null");
        }
        this.range = range;
        this.direction = direction;
    }

    public Range getRange() {
        return this.range;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.range.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectedRange)) {
            return false;
        }
        DirectedRange other = (DirectedRange)obj;
        if (this.direction != other.direction) {
            return false;
        }
        return this.range.equals(other.range);
    }

    public String toString() {
        return "DirectedRange [range=" + this.range + ", direction=" + (Object)((Object)this.direction) + "]";
    }

    @Override
    public Range asRange() {
        return this.getRange();
    }
}

