/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.util.slice.VariableWidthNucleotideSlice;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSlice;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSliceMap;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public final class VariableWidthNucleotideSliceMap
implements VariableWidthSliceMap<Nucleotide, NucleotideSequence> {
    private final VariableWidthNucleotideSlice[] slices;
    private final int widthPerSlice;
    private final NucleotideSequence gappedReferenceSequence;

    private VariableWidthNucleotideSliceMap(Builder builder) {
        this.widthPerSlice = builder.widthPerSlice;
        this.gappedReferenceSequence = builder.trimmedGappedReferenceSequence;
        this.slices = new VariableWidthNucleotideSlice[builder.builders.length];
        for (int i = 0; i < this.slices.length; ++i) {
            this.slices[i] = builder.builders[i].build();
        }
    }

    @Override
    public VariableWidthSlice<Nucleotide, NucleotideSequence> getSlice(int offset) {
        return this.slices[offset];
    }

    @Override
    public int getConsensusLength() {
        return (int)this.gappedReferenceSequence.getLength();
    }

    public Stream<VariableWidthSlice<Nucleotide, NucleotideSequence>> getSlicesThatIntersectGapped(Range gappedRange) {
        int startSliceOffset = this.gappedReferenceSequence.getUngappedOffsetFor((int)gappedRange.getBegin()) / this.widthPerSlice;
        int endSliceOffset = this.gappedReferenceSequence.getUngappedOffsetFor((int)gappedRange.getEnd()) / this.widthPerSlice;
        ArrayList<VariableWidthNucleotideSlice> list = new ArrayList<VariableWidthNucleotideSlice>(endSliceOffset - startSliceOffset + 1);
        for (int i = Math.max(0, startSliceOffset); i < this.slices.length && i <= endSliceOffset; ++i) {
            list.add(this.slices[i]);
        }
        return list.stream();
    }

    public Stream<VariableWidthSlice<Nucleotide, NucleotideSequence>> getSlicesThatIntersectUngapped(Range ungappedRange) {
        int startSliceOffset = (int)(ungappedRange.getBegin() / (long)this.widthPerSlice);
        int endSliceOffset = (int)(ungappedRange.getEnd() / (long)this.widthPerSlice);
        ArrayList<VariableWidthNucleotideSlice> list = new ArrayList<VariableWidthNucleotideSlice>(endSliceOffset - startSliceOffset + 1);
        for (int i = Math.max(0, startSliceOffset); i < this.slices.length && i <= endSliceOffset; ++i) {
            list.add(this.slices[i]);
        }
        return list.stream();
    }

    @Override
    public int getNumberOfSlices() {
        return this.slices.length;
    }

    public static class Builder {
        private final VariableWidthNucleotideSlice.Builder[] builders;
        private final int widthPerSlice;
        private final NucleotideSequence trimmedGappedReferenceSequence;
        private final List<DirectedRange> gappedExons;

        public Builder(NucleotideSequence gappedReferenceSequence, int ungappedWidthPerSlice) {
            this(gappedReferenceSequence, ungappedWidthPerSlice, DirectedRange.create(Range.ofLength(gappedReferenceSequence.getLength())));
        }

        public Builder(NucleotideSequence gappedReferenceSequence, int ungappedWidthPerSlice, Range ... gappedExons) {
            this(gappedReferenceSequence, ungappedWidthPerSlice, Arrays.stream(gappedExons).map(DirectedRange::create).collect(Collectors.toList()));
        }

        public Builder(NucleotideSequence gappedReferenceSequence, int ungappedWidthPerSlice, DirectedRange ... gappedExons) {
            this(gappedReferenceSequence, ungappedWidthPerSlice, Arrays.asList(gappedExons));
        }

        private Builder(NucleotideSequence gappedReferenceSequence, int ungappedWidthPerSlice, List<DirectedRange> gappedExons) {
            this.gappedExons = gappedExons;
            Collections.sort(this.gappedExons, Comparator.comparing(DirectedRange::asRange, Range.Comparators.ARRIVAL));
            this.trimmedGappedReferenceSequence = this.getSplicedSequenceFor(gappedReferenceSequence, 0);
            long ungappedLength = this.trimmedGappedReferenceSequence.getUngappedLength();
            if ((long)ungappedWidthPerSlice > ungappedLength) {
                throw new IllegalArgumentException("width per slice must be less than ungapped length");
            }
            long rem = ungappedLength % (long)ungappedWidthPerSlice;
            if (rem != 0L) {
                throw new IllegalArgumentException("ungapped width per slice (" + ungappedWidthPerSlice + ") must be a factor of the ungapped sequence length " + ungappedLength);
            }
            int numberOfSlices = (int)(ungappedLength / (long)ungappedWidthPerSlice);
            this.widthPerSlice = ungappedWidthPerSlice;
            this.builders = new VariableWidthNucleotideSlice.Builder[numberOfSlices];
            Iterator<Nucleotide> iter = this.trimmedGappedReferenceSequence.iterator();
            int i = 0;
            int currentGappedOffset = 0;
            while (iter.hasNext()) {
                NucleotideSequence gappedRefSubSeq = this.computeNumberOfGappedBasesReferenceSlice(ungappedWidthPerSlice, iter);
                this.builders[i++] = new VariableWidthNucleotideSlice.Builder(gappedRefSubSeq, currentGappedOffset);
                currentGappedOffset += (int)gappedRefSubSeq.getLength();
            }
        }

        private NucleotideSequence getSplicedSequenceFor(NucleotideSequence gappedReferenceSequence, int startOffset) {
            Range gappedFullReferenceRange = new Range.Builder(gappedReferenceSequence.getLength()).shift(startOffset).build();
            Optional<DirectedRange> intersect = this.gappedExons.stream().filter(exon -> exon.asRange().intersects(gappedFullReferenceRange)).findAny();
            if (!intersect.isPresent()) {
                return new NucleotideSequenceBuilder().build();
            }
            long seqLength = gappedReferenceSequence.getLength();
            Range fullSeqRange = Range.ofLength(seqLength);
            NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder((int)seqLength);
            for (DirectedRange dr : this.gappedExons) {
                Range seqRange = new Range.Builder(dr.asRange()).shift(-startOffset).build();
                Range seqRangeToKeep = seqRange.intersection(fullSeqRange);
                if (seqRangeToKeep.isEmpty()) continue;
                NucleotideSequenceBuilder exon2 = (NucleotideSequenceBuilder)gappedReferenceSequence.toBuilder(seqRangeToKeep);
                if (dr.getDirection() == Direction.REVERSE) {
                    exon2.reverseComplement();
                }
                builder.append(exon2);
            }
            return builder.build();
        }

        private NucleotideSequence computeNumberOfGappedBasesReferenceSlice(int ungappedWidthPerSlice, Iterator<Nucleotide> iter) {
            NucleotideSequenceBuilder builder = new NucleotideSequenceBuilder(ungappedWidthPerSlice * 2);
            while (iter.hasNext() && builder.getUngappedLength() < (long)ungappedWidthPerSlice) {
                builder.append(iter.next());
            }
            return builder.build();
        }

        public Builder add(int offset, NucleotideSequence seq) {
            NucleotideSequence splicedSequence = this.getSplicedSequenceFor(seq, offset);
            if (splicedSequence.getLength() == 0L) {
                return this;
            }
            int splicedStartOffset = this.getSplicedStartOffsetFor(offset);
            int flankingGappedRefOffset = AssemblyUtil.getRightFlankingNonGapIndex(this.trimmedGappedReferenceSequence, splicedStartOffset);
            int ungappedStartOffset = this.trimmedGappedReferenceSequence.getUngappedOffsetFor(flankingGappedRefOffset);
            int currentOffset = ungappedStartOffset / this.widthPerSlice;
            Iterator<Nucleotide> iter = splicedSequence.iterator();
            this.builders[currentOffset++].addBeginningOfRead(splicedStartOffset, iter);
            while (iter.hasNext() && currentOffset < this.builders.length) {
                this.builders[currentOffset++].add(iter);
            }
            return this;
        }

        private int getSplicedStartOffsetFor(int offset) {
            Range upstreamOfRead = Range.ofLength(offset);
            List<Range> upstreamIntrons = upstreamOfRead.complementOf(this.gappedExons);
            if (upstreamIntrons.isEmpty()) {
                int exonStart = (int)this.gappedExons.get(0).getBegin();
                if (offset < exonStart) {
                    return 0;
                }
                if (exonStart <= offset) {
                    return offset - exonStart;
                }
                return offset;
            }
            long intronLength = 0L;
            for (Range r : upstreamIntrons) {
                intronLength += r.getLength();
            }
            return offset - (int)intronLength;
        }

        public VariableWidthNucleotideSliceMap build() {
            return new VariableWidthNucleotideSliceMap(this);
        }
    }
}

