/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSliceElement;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.util.JoinedStringBuilder;

public class VariableWidthNucleotideSliceElement
implements VariableWidthSliceElement<Nucleotide> {
    private final int count;
    private final List<Nucleotide> list;

    public VariableWidthNucleotideSliceElement(List<Nucleotide> list, int count) {
        this.list = new ArrayList<Nucleotide>(list);
        this.count = count;
    }

    @Override
    public List<Nucleotide> get() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public int getLength() {
        return this.list.size();
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public String toString() {
        return JoinedStringBuilder.create(this.list).prefix("[").suffix(" = " + this.count + "]").build();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + this.list.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableWidthSliceElement)) {
            return false;
        }
        VariableWidthSliceElement other = (VariableWidthSliceElement)obj;
        if (this.count != other.getCount()) {
            return false;
        }
        return this.list.equals(other.get());
    }
}

