/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jcvi.jillion.assembly.util.slice.VariableWidthNucleotideSliceElement;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSlice;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSliceElement;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.JoinedStringBuilder;

final class VariableWidthNucleotideSlice
implements VariableWidthSlice<Nucleotide, NucleotideSequence> {
    private final List<VariableWidthSliceElement<Nucleotide>> list = new ArrayList<VariableWidthSliceElement<Nucleotide>>();
    private final NucleotideSequence gappedReference;

    private VariableWidthNucleotideSlice(Builder builder) {
        for (Map.Entry entry : builder.countMap.entrySet()) {
            this.list.add(new VariableWidthNucleotideSliceElement((List)entry.getKey(), ((LongAdder)entry.getValue()).intValue()));
        }
        Collections.sort(this.list);
        this.gappedReference = builder.gappedReference;
    }

    @Override
    public NucleotideSequence getGappedReferenceSequence() {
        return this.gappedReference;
    }

    @Override
    public int getSliceLength() {
        return this.list.stream().mapToInt(e -> e.getLength()).max().orElse(0);
    }

    @Override
    public int getCoverageDepth() {
        int coverage = 0;
        for (VariableWidthSliceElement<Nucleotide> e : this.list) {
            coverage += e.getCount();
        }
        return coverage;
    }

    @Override
    public int getCountFor(List<Nucleotide> sliceElementSeq) {
        Objects.requireNonNull(sliceElementSeq);
        Optional<VariableWidthSliceElement> ret = this.list.stream().filter(e -> sliceElementSeq.equals(e.get())).findFirst();
        if (ret.isPresent()) {
            return ret.get().getCount();
        }
        return 0;
    }

    @Override
    public Stream<? extends VariableWidthSliceElement<Nucleotide>> elements() {
        return this.list.stream();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.list.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableWidthSlice)) {
            return false;
        }
        if (obj instanceof VariableWidthNucleotideSlice) {
            VariableWidthNucleotideSlice other = (VariableWidthNucleotideSlice)obj;
            return this.list.equals(other.list);
        }
        VariableWidthSlice other = (VariableWidthSlice)obj;
        return this.list.equals(other.elements().map(o -> (VariableWidthSlice)((Object)o)).collect(Collectors.toList()));
    }

    public String toString() {
        return JoinedStringBuilder.create(this.list).prefix("[ ").glue(", ").suffix(" ]").build();
    }

    public static class Builder {
        private final int width;
        private final int startOffset;
        private final NucleotideSequence gappedReference;
        private final Map<List<Nucleotide>, LongAdder> countMap = new ConcurrentHashMap<List<Nucleotide>, LongAdder>();

        public Builder(NucleotideSequence gappedReference) {
            this(gappedReference, 0);
        }

        public Builder(NucleotideSequence gappedReference, int startOffset) {
            Objects.requireNonNull(gappedReference);
            if (gappedReference.getUngappedLength() < 0L) {
                throw new IllegalArgumentException("ungappedWidth must be >=1");
            }
            this.width = (int)gappedReference.getLength();
            this.gappedReference = gappedReference;
            this.startOffset = startOffset;
        }

        private void assertNoElementsNull(List<Nucleotide> list) {
            for (Nucleotide n : list) {
                Objects.requireNonNull(n);
            }
        }

        public Builder add(Iterator<Nucleotide> iter) {
            int count;
            ArrayList<Nucleotide> list = new ArrayList<Nucleotide>(this.width);
            for (count = 0; iter.hasNext() && count < this.width; ++count) {
                list.add(iter.next());
            }
            if (count == this.width) {
                return this.add(list);
            }
            return this;
        }

        public Builder add(Nucleotide ... nucleotides) {
            return this.add(Arrays.asList(nucleotides));
        }

        public Builder add(List<Nucleotide> list) {
            if (list.size() != this.width) {
                throw new IllegalArgumentException("width is not length " + this.width + " : " + list);
            }
            this.assertNoElementsNull(list);
            this.countMap.computeIfAbsent(list, k -> new LongAdder()).increment();
            return this;
        }

        public VariableWidthNucleotideSlice build() {
            return new VariableWidthNucleotideSlice(this);
        }

        public Builder addMultiple(int i, NucleotideSequence seq) {
            ArrayList<Nucleotide> list = new ArrayList<Nucleotide>();
            for (Nucleotide n : seq) {
                list.add(n);
            }
            this.countMap.computeIfAbsent(list, k -> new LongAdder()).add(i);
            return this;
        }

        public void skipBases(int gappedOffset, Iterator<Nucleotide> iter) {
            int numberOfBasesToSkip = this.width - (gappedOffset - this.startOffset);
            for (int i = 0; iter.hasNext() && i < numberOfBasesToSkip; ++i) {
                iter.next();
            }
        }

        public void addBeginningOfRead(int gappedStartOffset, Iterator<Nucleotide> iter) {
            if (this.startOffset == gappedStartOffset) {
                this.add(iter);
            } else {
                this.skipBases(gappedStartOffset, iter);
            }
        }
    }
}

