/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.Iterator;
import org.jcvi.jillion.assembly.util.slice.SingleNucleotideSlice;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSliceMap;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public class SingleNucleotideSliceMap
implements VariableWidthSliceMap<Nucleotide, NucleotideSequence> {
    private final SingleNucleotideSlice[] slices;

    private SingleNucleotideSliceMap(Builder builder) {
        this.slices = new SingleNucleotideSlice[builder.builders.length];
        for (int i = 0; i < this.slices.length; ++i) {
            this.slices[i] = builder.builders[i].build();
        }
    }

    public SingleNucleotideSlice getSlice(int offset) {
        return this.slices[offset];
    }

    @Override
    public int getConsensusLength() {
        return this.slices.length;
    }

    @Override
    public int getNumberOfSlices() {
        return this.getConsensusLength();
    }

    public static class Builder {
        private final SingleNucleotideSlice.Builder[] builders;

        public Builder(NucleotideSequence gappedReference) {
            this.builders = new SingleNucleotideSlice.Builder[(int)gappedReference.getLength()];
            Iterator iter = gappedReference.iterator();
            int i = 0;
            while (iter.hasNext()) {
                this.builders[i++] = new SingleNucleotideSlice.Builder((Nucleotide)iter.next());
            }
        }

        public Builder add(int offset, NucleotideSequence seq) {
            int currentOffset = offset;
            Iterator iter = seq.iterator();
            while (iter.hasNext()) {
                this.builders[currentOffset++].add((Nucleotide)iter.next());
            }
            return this;
        }

        public SingleNucleotideSliceMap build() {
            return new SingleNucleotideSliceMap(this);
        }
    }
}

