/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSliceElement;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public class SingleNucleotideSliceElement
implements VariableWidthSliceElement<Nucleotide> {
    private final int count;
    private final Nucleotide base;

    public SingleNucleotideSliceElement(Nucleotide base, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be >=0");
        }
        Objects.requireNonNull(base);
        this.base = base;
        this.count = count;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public List<Nucleotide> get() {
        return Collections.singletonList(this.base);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.count;
        result = 31 * result + this.base.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableWidthSliceElement)) {
            return false;
        }
        if (obj instanceof SingleNucleotideSliceElement) {
            SingleNucleotideSliceElement other = (SingleNucleotideSliceElement)obj;
            if (this.count != other.count) {
                return false;
            }
            return this.base == other.base;
        }
        VariableWidthSliceElement other = (VariableWidthSliceElement)obj;
        if (this.count != other.getCount()) {
            return false;
        }
        return this.get().equals(other.get());
    }

    public String toString() {
        return "SingleNucleotideSliceElement [" + this.base + ", count=" + this.count + "]";
    }
}

