/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jcvi.jillion.assembly.util.slice.SingleNucleotideSliceElement;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSlice;
import org.jcvi.jillion.assembly.util.slice.VariableWidthSliceElement;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

final class SingleNucleotideSlice
implements VariableWidthSlice<Nucleotide, NucleotideSequence> {
    private static final int NUMBER_OF_NUCLEOTIDES = Nucleotide.values().length;
    private static final Map<Nucleotide, NucleotideSequence> SEQ_MAP = new EnumMap<Nucleotide, NucleotideSequence>(Nucleotide.class);
    private final Map<Nucleotide, SingleNucleotideSliceElement> map = new EnumMap<Nucleotide, SingleNucleotideSliceElement>(Nucleotide.class);
    private final NucleotideSequence refSeq;

    private SingleNucleotideSlice(Builder builder) {
        for (int i = 0; i < NUMBER_OF_NUCLEOTIDES; ++i) {
            int count = builder.counts[i];
            if (count <= 0) continue;
            Nucleotide n = Nucleotide.getByOrdinal(i);
            this.map.put(n, new SingleNucleotideSliceElement(n, count));
        }
        this.refSeq = SEQ_MAP.get(builder.ref);
    }

    @Override
    public NucleotideSequence getGappedReferenceSequence() {
        return this.refSeq;
    }

    public int getCountFor(Nucleotide n) {
        Objects.requireNonNull(n);
        SingleNucleotideSliceElement ret = this.map.get(n);
        if (ret == null) {
            return 0;
        }
        return ret.getCount();
    }

    @Override
    public int getCountFor(List<Nucleotide> sliceElementSeq) {
        int seqLength = sliceElementSeq.size();
        if (seqLength != 1) {
            return 0;
        }
        Nucleotide n = sliceElementSeq.get(0);
        return this.getCountFor(n);
    }

    @Override
    public int getSliceLength() {
        return 1;
    }

    @Override
    public int getCoverageDepth() {
        int coverage = 0;
        for (VariableWidthSliceElement variableWidthSliceElement : this.map.values()) {
            coverage += variableWidthSliceElement.getCount();
        }
        return coverage;
    }

    @Override
    public Stream<SingleNucleotideSliceElement> elements() {
        return this.map.values().stream();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.map.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableWidthSlice)) {
            return false;
        }
        if (obj instanceof SingleNucleotideSlice) {
            SingleNucleotideSlice other = (SingleNucleotideSlice)obj;
            return this.map.equals(other.map);
        }
        VariableWidthSlice other = (VariableWidthSlice)obj;
        return this.map.equals(other.elements().map(o -> (VariableWidthSlice)((Object)o)).collect(Collectors.toList()));
    }

    public String toString() {
        return "SingleNucleotideSlice [list=" + this.map + "]";
    }

    static /* synthetic */ int access$200() {
        return NUMBER_OF_NUCLEOTIDES;
    }

    static {
        for (Nucleotide n : Nucleotide.getDnaValues()) {
            SEQ_MAP.put(n, new NucleotideSequenceBuilder(1).append(n).build());
        }
    }

    public static class Builder {
        private int[] counts = new int[SingleNucleotideSlice.access$200()];
        private final Nucleotide ref;

        public Builder(Nucleotide ref) {
            this.ref = ref;
        }

        public Builder add(Nucleotide n) {
            byte by = n.getOrdinalAsByte();
            this.counts[by] = this.counts[by] + 1;
            return this;
        }

        public SingleNucleotideSlice build() {
            return new SingleNucleotideSlice(this);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("{");
            for (int i = 0; i < this.counts.length; ++i) {
                if (this.counts[i] <= 0) continue;
                b.append(Nucleotide.getDnaValues().get(i)).append(':').append(this.counts[i]).append(' ');
            }
            b.append('}');
            return b.toString();
        }
    }
}

