/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.slice;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.jcvi.jillion.assembly.util.slice.VariableWidthNucleotideSliceMap;
import org.jcvi.jillion.core.DirectedRange;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

public class CodonSliceMapBuilder {
    private VariableWidthNucleotideSliceMap.Builder builder;
    private final RnaEdit rnaEdit;

    public static CodonSliceMapBuilder create(NucleotideSequence fullgappedSequence, Collection<DirectedRange> ungappedExons) {
        return new CodonSliceMapBuilder(ungappedExons, fullgappedSequence);
    }

    public CodonSliceMapBuilder(NucleotideSequence fullgappedSequence, Range ungappedExon) {
        this.builder = new VariableWidthNucleotideSliceMap.Builder(fullgappedSequence, 3, ungappedExon);
        this.rnaEdit = null;
    }

    public CodonSliceMapBuilder(NucleotideSequence fullgappedSequence, Collection<Range> ungappedExons) {
        this.builder = new VariableWidthNucleotideSliceMap.Builder(fullgappedSequence, 3, ungappedExons.toArray(new Range[ungappedExons.size()]));
        this.rnaEdit = null;
    }

    private CodonSliceMapBuilder(Collection<DirectedRange> ungappedExons, NucleotideSequence fullgappedSequence) {
        DirectedRange[] gappedExons = new DirectedRange[ungappedExons.size()];
        int i = 0;
        for (DirectedRange r : ungappedExons) {
            gappedExons[i++] = DirectedRange.create(fullgappedSequence.toGappedRange(r.getRange()), r.getDirection());
        }
        this.builder = new VariableWidthNucleotideSliceMap.Builder(fullgappedSequence, 3, gappedExons);
        this.rnaEdit = null;
    }

    public CodonSliceMapBuilder(NucleotideSequence fullgappedSequence, Range ungappedExon, RnaEdit rnaEdit) {
        this.rnaEdit = rnaEdit;
        NucleotideSequence editedReference = rnaEdit.editReference(fullgappedSequence).build();
        Range updatedUngappedExon = new Range.Builder(ungappedExon).expandEnd(rnaEdit.getNumberOfBasesAdded()).build();
        Range gappedEditedExon = Range.of(editedReference.getGappedOffsetFor((int)updatedUngappedExon.getBegin()), (long)editedReference.getGappedOffsetFor((int)updatedUngappedExon.getEnd()));
        this.builder = new VariableWidthNucleotideSliceMap.Builder(editedReference, 3, gappedEditedExon);
    }

    public CodonSliceMapBuilder add(int offset, NucleotideSequence seq) {
        if (this.rnaEdit == null) {
            this.builder.add(offset, seq);
        } else {
            int adjustedStartOffset = this.rnaEdit.adjustStartOffset(offset);
            NucleotideSequenceBuilder editedReadBuilder = this.rnaEdit.editRead(seq, new Range.Builder(seq.getLength()).shift(adjustedStartOffset).build());
            int lastNonGapOffset = editedReadBuilder.getGappedOffsetFor((int)(editedReadBuilder.getUngappedLength() - 1L));
            long numberOfTrailingGaps = editedReadBuilder.getLength() - (long)lastNonGapOffset - 1L;
            if (numberOfTrailingGaps > 0L) {
                editedReadBuilder.delete(new Range.Builder(numberOfTrailingGaps).shift(lastNonGapOffset + 1).build());
            }
            this.builder.add(adjustedStartOffset, editedReadBuilder.build());
        }
        return this;
    }

    public VariableWidthNucleotideSliceMap build() {
        return this.builder.build();
    }

    public static class RnaEdit {
        private final Range ungappedRegion;
        private Range gappedCdsRange;
        private final NucleotideSequence inputSequence;
        private final NucleotideSequence editedSequence;
        private final int numberOfBasesAdded;

        public RnaEdit(Range ungappedRegion, NucleotideSequence inputSequence, NucleotideSequence editedSequence) {
            Objects.requireNonNull(ungappedRegion);
            Objects.requireNonNull(inputSequence);
            Objects.requireNonNull(editedSequence);
            if (ungappedRegion.getLength() != inputSequence.getUngappedLength()) {
                throw new IllegalArgumentException("ungapped region does not match ungapped input sequence length " + ungappedRegion.getLength() + "  vs  " + inputSequence.getUngappedLength());
            }
            this.ungappedRegion = ungappedRegion;
            this.inputSequence = inputSequence;
            this.editedSequence = editedSequence;
            this.numberOfBasesAdded = (int)(editedSequence.getLength() - inputSequence.getLength());
        }

        public int getNumberOfBasesAdded() {
            return this.numberOfBasesAdded;
        }

        public int adjustStartOffset(int oldGappedOffset) {
            if ((long)oldGappedOffset > this.gappedCdsRange.getEnd()) {
                return oldGappedOffset + this.numberOfBasesAdded;
            }
            return oldGappedOffset;
        }

        protected void doEdit(int offset, NucleotideSequenceBuilder seq) {
            if (seq.isEqualToIgnoringGaps(this.inputSequence)) {
                int[] gaps = seq.getGapOffsets();
                seq.clear().append(this.editedSequence);
                for (int i = 0; i < gaps.length; ++i) {
                    seq.insert(gaps[i], Nucleotide.Gap);
                }
            } else {
                char[] gaps = new char[this.numberOfBasesAdded];
                Arrays.fill(gaps, '-');
                seq.append(gaps);
            }
        }

        protected void doEditMissing(NucleotideSequenceBuilder builder, long numberOfLeadingBasesMissing) {
            char[] trailingGaps = new char[this.numberOfBasesAdded];
            Arrays.fill(trailingGaps, '-');
            builder.append(trailingGaps);
        }

        public final NucleotideSequenceBuilder editReference(NucleotideSequence ref) {
            NucleotideSequenceBuilder builder = ref.toBuilder();
            this.gappedCdsRange = builder.toGappedRange(this.ungappedRegion);
            NucleotideSequenceBuilder portionToEdit = builder.copy(this.gappedCdsRange);
            this.doEdit((int)this.gappedCdsRange.getBegin(), portionToEdit);
            return builder.replace(this.gappedCdsRange, portionToEdit);
        }

        public final NucleotideSequenceBuilder editRead(NucleotideSequence seq, Range gappedRefRange) {
            Range intersection = gappedRefRange.intersection(this.gappedCdsRange);
            if (intersection.isEmpty()) {
                return seq.toBuilder();
            }
            NucleotideSequenceBuilder builder = seq.toBuilder();
            Range editRegion = new Range.Builder(intersection).shift(-gappedRefRange.getBegin()).build();
            NucleotideSequenceBuilder portionToEdit = builder.copy(editRegion);
            long numberOfLeadingBasesMissing = intersection.getBegin() - this.gappedCdsRange.getBegin();
            if (numberOfLeadingBasesMissing > 0L) {
                this.doEditMissing(portionToEdit, numberOfLeadingBasesMissing);
            } else {
                this.doEdit((int)this.gappedCdsRange.getBegin(), portionToEdit);
            }
            return builder.replace(editRegion, portionToEdit);
        }
    }
}

