/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.EnumSet;
import java.util.Set;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.assembly.util.consensus.AbstractChurchillWatermanConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusProbabilities;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public class TigrAnnotationConsensusCaller
extends AbstractChurchillWatermanConsensusCaller {
    public TigrAnnotationConsensusCaller(PhredQuality highQualityThreshold) {
        super(highQualityThreshold);
    }

    @Override
    protected Nucleotide getConsensus(ConsensusProbabilities normalizedConsensusProbabilities, Slice slice) {
        Set<Nucleotide> basesTowardsAmbiguity = this.getCWBasesTowardsAmbiguity(normalizedConsensusProbabilities, slice);
        basesTowardsAmbiguity.addAll(this.findAllHighQualityBases(slice));
        return Nucleotide.getAmbiguityFor(basesTowardsAmbiguity);
    }

    private Set<Nucleotide> getCWBasesTowardsAmbiguity(ConsensusProbabilities normalizedErrorProbabilityStruct, Slice slice) {
        int numberOfDifferentBasesInSlice = 0;
        for (int counts : slice.getNucleotideCounts().values()) {
            if (counts <= 0) continue;
            ++numberOfDifferentBasesInSlice;
        }
        return this.getBasesUsedTowardsAmbiguity(normalizedErrorProbabilityStruct, numberOfDifferentBasesInSlice);
    }

    private Set<Nucleotide> findAllHighQualityBases(Slice slice) {
        EnumSet<Nucleotide> highQualityDiffs = EnumSet.noneOf(Nucleotide.class);
        for (SliceElement sliceElement : slice) {
            if (sliceElement.getQuality().compareTo(this.getHighQualityThreshold()) < 0) continue;
            highQualityDiffs.add(sliceElement.getBase());
        }
        return highQualityDiffs;
    }
}

