/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.consensus.AbstractChurchillWatermanConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusProbabilities;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public class NoAmbiguityConsensusCaller
extends AbstractChurchillWatermanConsensusCaller {
    public NoAmbiguityConsensusCaller(PhredQuality highQualityThreshold) {
        super(highQualityThreshold);
    }

    @Override
    protected Nucleotide getConsensus(ConsensusProbabilities normalizedConsensusProbabilities, Slice slice) {
        Nucleotide result = Nucleotide.Adenine;
        double lowestErrorProbability = normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Adenine);
        if (normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Cytosine).compareTo(lowestErrorProbability) < 0) {
            result = Nucleotide.Cytosine;
            lowestErrorProbability = normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Cytosine);
        }
        if (normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Guanine).compareTo(lowestErrorProbability) < 0) {
            result = Nucleotide.Guanine;
            lowestErrorProbability = normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Guanine);
        }
        if (normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Thymine).compareTo(lowestErrorProbability) < 0) {
            result = Nucleotide.Thymine;
            lowestErrorProbability = normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Thymine);
        }
        if (normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Gap).compareTo(lowestErrorProbability) < 0) {
            result = Nucleotide.Gap;
            lowestErrorProbability = normalizedConsensusProbabilities.getProbabilityFor(Nucleotide.Gap);
        }
        return result;
    }
}

