/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusResult;
import org.jcvi.jillion.assembly.util.consensus.DefaultConsensusResult;
import org.jcvi.jillion.assembly.util.consensus.MostFrequentBasecallConsensusCaller;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public class NextGenReferenceConsensusRecaller
implements ConsensusCaller {
    private static final SliceBuilder.SliceElementFilter FORWARD_FILTER = new SliceBuilder.SliceElementFilter(){

        @Override
        public boolean accept(SliceElement e) {
            return e.getDirection() == Direction.FORWARD;
        }
    };
    private static final SliceBuilder.SliceElementFilter REVERSE_FILTER = new SliceBuilder.SliceElementFilter(){

        @Override
        public boolean accept(SliceElement e) {
            return e.getDirection() == Direction.REVERSE;
        }
    };
    private static final int MIN_QUALITY = 5;
    private final ConsensusCaller delegateConsensusCaller;

    public NextGenReferenceConsensusRecaller() {
        this(MostFrequentBasecallConsensusCaller.INSTANCE);
    }

    public NextGenReferenceConsensusRecaller(ConsensusCaller delegateConsensusCaller) {
        if (delegateConsensusCaller == null) {
            throw new NullPointerException("delegate consensus caller can not be null");
        }
        this.delegateConsensusCaller = delegateConsensusCaller;
    }

    @Override
    public ConsensusResult callConsensus(Slice slice) {
        ConsensusResult delegatedResult = this.getDelegateConsensus(slice);
        Nucleotide originalConsensus = slice.getConsensusCall();
        if (delegatedResult.getConsensus().isGap() && !originalConsensus.isGap()) {
            return this.handleDeletion(slice, delegatedResult, originalConsensus);
        }
        if (!delegatedResult.getConsensus().isGap() && originalConsensus.isGap()) {
            return this.handleInsertion(slice, delegatedResult);
        }
        return delegatedResult;
    }

    private ConsensusResult handleInsertion(Slice slice, ConsensusResult majorityBase) {
        SliceBuilder all = new SliceBuilder(slice);
        Slice forwardSlice = all.copy().filter(FORWARD_FILTER).build();
        Slice reverseSlice = all.copy().filter(REVERSE_FILTER).build();
        if (forwardSlice.getCoverageDepth() == 0 || reverseSlice.getCoverageDepth() == 0) {
            return majorityBase;
        }
        ConsensusResult forwardMajority = this.getDelegateConsensus(forwardSlice);
        ConsensusResult reverseMajority = this.getDelegateConsensus(reverseSlice);
        if (forwardMajority.getConsensus().equals(reverseMajority.getConsensus())) {
            return majorityBase;
        }
        Nucleotide recalledConsensus = forwardMajority.getConsensus().isGap() ? forwardMajority.getConsensus() : reverseMajority.getConsensus();
        int qualScore = this.computeCumlativeQualityConsensus(slice, recalledConsensus);
        return new DefaultConsensusResult(recalledConsensus, qualScore);
    }

    private ConsensusResult handleDeletion(Slice slice, ConsensusResult majorityBase, Nucleotide originalConsensus) {
        Nucleotide recalledConsensus;
        SliceBuilder all = new SliceBuilder(slice);
        Slice forwardSlice = all.copy().filter(FORWARD_FILTER).build();
        Slice reverseSlice = all.copy().filter(REVERSE_FILTER).build();
        ConsensusResult forwardMajority = this.getDelegateConsensus(forwardSlice);
        ConsensusResult reverseMajority = this.getDelegateConsensus(reverseSlice);
        if (forwardSlice.getCoverageDepth() == 0 || reverseSlice.getCoverageDepth() == 0) {
            return majorityBase;
        }
        if (forwardMajority.getConsensus().equals(reverseMajority.getConsensus())) {
            return majorityBase;
        }
        if (forwardMajority.getConsensus().isGap()) {
            recalledConsensus = reverseMajority.getConsensus();
        } else if (reverseMajority.getConsensus().isGap()) {
            recalledConsensus = forwardMajority.getConsensus();
        } else if (forwardMajority.getConsensus().equals(originalConsensus)) {
            recalledConsensus = forwardMajority.getConsensus();
        } else if (reverseMajority.getConsensus().equals(originalConsensus)) {
            recalledConsensus = reverseMajority.getConsensus();
        } else {
            return majorityBase;
        }
        int qualScore = this.computeCumlativeQualityConsensus(slice, recalledConsensus);
        return new DefaultConsensusResult(recalledConsensus, qualScore);
    }

    private ConsensusResult getDelegateConsensus(Slice slice) {
        return this.delegateConsensusCaller.callConsensus(slice);
    }

    private int computeCumlativeQualityConsensus(Slice slice, Nucleotide consensus) {
        int sum = 0;
        for (SliceElement e : slice) {
            if (e.getBase() == consensus) {
                sum += e.getQuality().getQualityScore();
                continue;
            }
            sum -= e.getQuality().getQualityScore();
        }
        return Math.max(5, sum);
    }
}

