/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusResult;
import org.jcvi.jillion.assembly.util.consensus.DefaultConsensusResult;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.util.MapValueComparator;
import org.jcvi.jillion.core.util.SingleThreadAdder;

public enum MostFrequentBasecallConsensusCaller implements ConsensusCaller
{
    INSTANCE;


    @Override
    public ConsensusResult callConsensus(Slice slice) {
        if (slice == null) {
            return new DefaultConsensusResult(Nucleotide.Unknown, 0);
        }
        EnumMap<Nucleotide, SingleThreadAdder> histogramMap = new EnumMap<Nucleotide, SingleThreadAdder>(Nucleotide.class);
        EnumMap<Nucleotide, SingleThreadAdder> qualitySums = new EnumMap<Nucleotide, SingleThreadAdder>(Nucleotide.class);
        for (SliceElement sliceElement : slice) {
            Nucleotide base = sliceElement.getBase();
            SingleThreadAdder sum = (SingleThreadAdder)histogramMap.get(base);
            if (sum == null) {
                histogramMap.put(base, new SingleThreadAdder(1L));
                qualitySums.put(base, new SingleThreadAdder(sliceElement.getQuality().getQualityScore()));
                continue;
            }
            sum.increment();
            ((SingleThreadAdder)qualitySums.get(base)).add(sliceElement.getQuality().getQualityScore());
        }
        Nucleotide consensus = this.findMostOccuringBaseWithHighestQvs(histogramMap, qualitySums);
        int sum = this.getCumulativeQualityConsensusValue(qualitySums, consensus);
        return new DefaultConsensusResult(consensus, sum);
    }

    private int getCumulativeQualityConsensusValue(Map<Nucleotide, SingleThreadAdder> qualitySums, Nucleotide consensus) {
        int sum = 0;
        for (Map.Entry<Nucleotide, SingleThreadAdder> entry : qualitySums.entrySet()) {
            if (entry.getKey() == consensus) {
                sum += entry.getValue().intValue();
                continue;
            }
            sum -= entry.getValue().intValue();
        }
        return sum;
    }

    private Nucleotide findMostOccuringBaseWithHighestQvs(Map<Nucleotide, SingleThreadAdder> histogramMap, Map<Nucleotide, SingleThreadAdder> qualitySums) {
        Map.Entry next;
        if (histogramMap.isEmpty()) {
            return Nucleotide.Unknown;
        }
        HashMap<Nucleotide, Integer> intMap = new HashMap<Nucleotide, Integer>();
        for (Map.Entry<Nucleotide, SingleThreadAdder> entry : histogramMap.entrySet()) {
            intMap.put(entry.getKey(), entry.getValue().intValue());
        }
        SortedMap sortedMap = MapValueComparator.sortDescending(intMap);
        Iterator iter = sortedMap.entrySet().iterator();
        Map.Entry most = iter.next();
        Nucleotide consensus = (Nucleotide)most.getKey();
        int count = (Integer)most.getValue();
        int bestQv = qualitySums.get(consensus).intValue();
        while (iter.hasNext() && (Integer)(next = iter.next()).getValue() >= count) {
            int currentQv = qualitySums.get(next.getKey()).intValue();
            if (currentQv <= bestQv) continue;
            bestQv = currentQv;
            consensus = (Nucleotide)next.getKey();
        }
        return consensus;
    }
}

