/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.util.consensus.ConsensusUtil;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

final class ConsensusProbabilities {
    private static final double ONE_TENTH = 0.1;
    private static final double ONE_QUARTER = 0.25;
    private final Map<Nucleotide, Double> probabilityMap;

    ConsensusProbabilities(Map<Nucleotide, Double> probabilityMap) {
        this.probabilityMap = Collections.unmodifiableMap(new EnumMap<Nucleotide, Double>(probabilityMap));
    }

    ConsensusProbabilities(Nucleotide consensus, int cumulativeQualityValue) {
        double probability = Math.pow(0.1, (double)cumulativeQualityValue * 0.1);
        this.probabilityMap = new EnumMap<Nucleotide, Double>(Nucleotide.class);
        for (Nucleotide currentBase : ConsensusUtil.BASES_TO_CONSIDER) {
            if (currentBase == consensus) {
                this.probabilityMap.put(currentBase, 1.0 - probability);
                continue;
            }
            this.probabilityMap.put(currentBase, probability * 0.25);
        }
    }

    public Double getProbabilityFor(Nucleotide base) {
        if (base == null) {
            throw new NullPointerException("base can not be null");
        }
        return this.probabilityMap.get(base);
    }

    public ConsensusProbabilities normalize() {
        double sumOfRawProbabilities = 0.0;
        for (Nucleotide currentBase : ConsensusUtil.BASES_TO_CONSIDER) {
            sumOfRawProbabilities += this.probabilityMap.get(currentBase).doubleValue();
        }
        EnumMap<Nucleotide, Double> newMap = new EnumMap<Nucleotide, Double>(Nucleotide.class);
        newMap.put(Nucleotide.Adenine, this.computeNormalizedProbabilityFor(Nucleotide.Adenine, sumOfRawProbabilities));
        newMap.put(Nucleotide.Cytosine, this.computeNormalizedProbabilityFor(Nucleotide.Cytosine, sumOfRawProbabilities));
        newMap.put(Nucleotide.Guanine, this.computeNormalizedProbabilityFor(Nucleotide.Guanine, sumOfRawProbabilities));
        newMap.put(Nucleotide.Thymine, this.computeNormalizedProbabilityFor(Nucleotide.Thymine, sumOfRawProbabilities));
        newMap.put(Nucleotide.Gap, this.computeNormalizedProbabilityFor(Nucleotide.Gap, sumOfRawProbabilities));
        return new ConsensusProbabilities(newMap);
    }

    private Double computeNormalizedProbabilityFor(Nucleotide base, double sumOfRawProbabilities) {
        double result = 0.0;
        for (Nucleotide currentBase : ConsensusUtil.BASES_TO_CONSIDER) {
            if (currentBase == base) continue;
            result += this.probabilityMap.get(currentBase).doubleValue();
        }
        return result / sumOfRawProbabilities;
    }

    public Set<Map.Entry<Nucleotide, Double>> entrySet() {
        return this.probabilityMap.entrySet();
    }

    public String toString() {
        return "ProbabilityStruct [probabilityMap=" + this.probabilityMap + "]";
    }
}

