/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;

class ConsensusCombiner {
    List<SliceBuilder> builders = new ArrayList<SliceBuilder>();

    ConsensusCombiner() {
    }

    public void add(SliceElement[] seq) {
        this.add(seq, 0);
    }

    public void add(SliceElement[] seq, int startOffset) {
        this.ensureSize(startOffset + seq.length);
        for (int i = startOffset; i < seq.length; ++i) {
            SliceElement element = seq[i];
            if (element == null) continue;
            this.builders.get(i).add(element);
        }
    }

    public void setReferenceSequence(NucleotideSequence consensus) {
        Iterator refIter = consensus.iterator();
        Iterator<SliceBuilder> sliceIter = this.builders.iterator();
        while (refIter.hasNext() && sliceIter.hasNext()) {
            sliceIter.next().setConsensus((Nucleotide)refIter.next());
        }
    }

    public ConsensusCombiner merge(ConsensusCombiner other) {
        this.ensureSize(other.builders.size());
        int currentSize = this.builders.size();
        for (int i = 0; i < currentSize; ++i) {
            this.builders.get(i).addAll(other.builders.get(i));
        }
        return this;
    }

    private void ensureSize(int length) {
        int delta = length - this.builders.size();
        for (int i = 0; i < delta; ++i) {
            this.builders.add(new SliceBuilder());
        }
    }

    public NucleotideSequenceBuilder computeConsensus(ConsensusCaller c) {
        NucleotideSequenceBuilder consensusBuilder = new NucleotideSequenceBuilder(this.builders.size());
        for (SliceBuilder b : this.builders) {
            consensusBuilder.append(c.callConsensus(b.build()).getConsensus());
        }
        return consensusBuilder;
    }
}

