/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCombiner;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.datastore.DataStoreEntry;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.internal.assembly.util.CompactedSliceElement;

public final class ConsensusCollectors {
    private ConsensusCollectors() {
    }

    public static Collector<SliceElement[], ConsensusCombiner, NucleotideSequence> toSliceConsensus(ConsensusCaller caller) {
        Objects.requireNonNull(caller);
        return Collector.of(ConsensusCombiner::new, ConsensusCombiner::add, ConsensusCombiner::merge, combiner -> combiner.computeConsensus(caller).turnOffDataCompression(true).build(), Collector.Characteristics.UNORDERED);
    }

    public static Collector<DataStoreEntry<NucleotideSequence>, ConsensusCombiner, NucleotideSequence> toDataStoreConsensus(ConsensusCaller caller) {
        return ConsensusCollectors.toDataStoreConsensus(caller, PhredQuality.valueOf(25));
    }

    public static Collector<DataStoreEntry<NucleotideSequence>, ConsensusCombiner, NucleotideSequence> toDataStoreConsensus(ConsensusCaller caller, PhredQuality defaultQuality) {
        return new DataStoreConsensusCaller(caller, defaultQuality);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller) {
        return ConsensusCollectors.toAssemblyConsensus(caller, PhredQuality.valueOf(25));
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, NucleotideSequence referenceOrOldConsensus) {
        return ConsensusCollectors.toAssemblyConsensus(caller, PhredQuality.valueOf(25), referenceOrOldConsensus);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, PhredQuality defaultQuality) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(defaultQuality);
        return new DefaultQualityAssemblyConsensusCollector(caller, defaultQuality);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, PhredQuality defaultQuality, NucleotideSequence referenceOrOldConsensus) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(defaultQuality);
        return new DefaultQualityAssemblyConsensusCollector(caller, defaultQuality, referenceOrOldConsensus);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, QualitySequenceDataStore gappedQualityDataStore) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(gappedQualityDataStore);
        return new AssemblyDataStoreConsensusCollector(caller, gappedQualityDataStore);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, QualitySequenceDataStore gappedQualityDataStore, NucleotideSequence referenceOrOldConsensus) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(gappedQualityDataStore);
        return new AssemblyDataStoreConsensusCollector(caller, gappedQualityDataStore, referenceOrOldConsensus);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, QualitySequenceDataStore rawQualityDataStore, GapQualityValueStrategy gapQualityValueStrategy) {
        return ConsensusCollectors.toAssemblyConsensus(caller, rawQualityDataStore, gapQualityValueStrategy, null);
    }

    public static Collector<AssembledRead, ConsensusCombiner, NucleotideSequence> toAssemblyConsensus(ConsensusCaller caller, QualitySequenceDataStore rawQualityDataStore, GapQualityValueStrategy gapQualityValueStrategy, NucleotideSequence referenceOrOldConsensus) {
        Objects.requireNonNull(caller);
        Objects.requireNonNull(rawQualityDataStore);
        Objects.requireNonNull(gapQualityValueStrategy);
        return new UngappedConverterAssemblyConsensusCollector(caller, rawQualityDataStore, gapQualityValueStrategy, referenceOrOldConsensus);
    }

    private static class AssemblyDataStoreConsensusCollector
    extends AbstractAssemblyConsensusCollector {
        private final QualitySequenceDataStore qualities;
        private NucleotideSequence referenceConsensus;

        public AssemblyDataStoreConsensusCollector(ConsensusCaller caller, QualitySequenceDataStore qualities) {
            this(caller, qualities, null);
        }

        public AssemblyDataStoreConsensusCollector(ConsensusCaller caller, QualitySequenceDataStore qualities, NucleotideSequence referenceConsensus) {
            super(caller);
            this.qualities = qualities;
            this.referenceConsensus = referenceConsensus;
        }

        @Override
        public Function<ConsensusCombiner, NucleotideSequence> finisher() {
            return combiner -> {
                if (this.referenceConsensus != null) {
                    combiner.setReferenceSequence(this.referenceConsensus);
                }
                return super.finisher().apply((ConsensusCombiner)combiner);
            };
        }

        @Override
        protected QualitySequence getQualitySequenceFor(AssembledRead read) {
            String id = read.getId();
            try {
                return this.toGappedQualitySequence(read, (QualitySequence)this.qualities.get(id));
            }
            catch (DataStoreException e) {
                throw new IllegalStateException("error getting quality values for read " + id);
            }
        }

        protected QualitySequence toGappedQualitySequence(AssembledRead read, QualitySequence quals) {
            if (read.getLength() != quals.getLength()) {
                throw new IllegalStateException("quality sequence length does not match gapped nucleotide sequence length " + read.getId());
            }
            return quals;
        }
    }

    private static class DefaultQualityAssemblyConsensusCollector
    extends AbstractAssemblyConsensusCollector {
        private final byte defaultQuality;
        private final NucleotideSequence referenceConsensus;

        protected DefaultQualityAssemblyConsensusCollector(ConsensusCaller caller, PhredQuality defaultQuality) {
            this(caller, defaultQuality, null);
        }

        protected DefaultQualityAssemblyConsensusCollector(ConsensusCaller caller, PhredQuality defaultQuality, NucleotideSequence reference) {
            super(caller);
            this.defaultQuality = defaultQuality.getQualityScore();
            this.referenceConsensus = reference;
        }

        @Override
        public Function<ConsensusCombiner, NucleotideSequence> finisher() {
            return combiner -> {
                if (this.referenceConsensus != null) {
                    combiner.setReferenceSequence(this.referenceConsensus);
                }
                return super.finisher().apply((ConsensusCombiner)combiner);
            };
        }

        @Override
        protected QualitySequence getQualitySequenceFor(AssembledRead read) {
            int length = (int)read.getLength();
            byte[] array = new byte[length];
            Arrays.fill(array, this.defaultQuality);
            return new QualitySequenceBuilder(array).turnOffDataCompression(true).build();
        }
    }

    private static abstract class AbstractConsensusCollector<T>
    implements Collector<T, ConsensusCombiner, NucleotideSequence> {
        private final ConsensusCaller caller;

        public AbstractConsensusCollector(ConsensusCaller caller) {
            this.caller = caller;
        }

        @Override
        public Supplier<ConsensusCombiner> supplier() {
            return ConsensusCombiner::new;
        }

        @Override
        public BiConsumer<ConsensusCombiner, T> accumulator() {
            return this::addRead;
        }

        protected abstract QualitySequence getQualitySequenceFor(T var1);

        protected abstract NucleotideSequence getSequenceFor(T var1);

        protected abstract int getStartOffset(T var1);

        protected abstract int getLength(T var1);

        protected abstract String getId(T var1);

        protected abstract Direction getDirection(T var1);

        protected void addRead(ConsensusCombiner combiner, T read) {
            int startOffset = this.getStartOffset(read);
            int length = this.getLength(read);
            SliceElement[] array = new SliceElement[length];
            String id = this.getId(read);
            int i = 0;
            NucleotideSequence seq = this.getSequenceFor(read);
            QualitySequence quals = this.getQualitySequenceFor(read);
            Iterator nIter = seq.iterator();
            Iterator qIter = quals.iterator();
            Direction dir = this.getDirection(read);
            while (nIter.hasNext()) {
                Nucleotide n = (Nucleotide)nIter.next();
                PhredQuality q = (PhredQuality)qIter.next();
                array[i++] = new CompactedSliceElement(id, n, q, dir);
            }
            combiner.add(array, startOffset);
        }

        @Override
        public BinaryOperator<ConsensusCombiner> combiner() {
            return ConsensusCombiner::merge;
        }

        @Override
        public Function<ConsensusCombiner, NucleotideSequence> finisher() {
            return combiner -> combiner.computeConsensus(this.caller).turnOffDataCompression(true).build();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    private static class DataStoreConsensusCaller
    extends AbstractConsensusCollector<DataStoreEntry<NucleotideSequence>> {
        private final byte defaultQuality;

        public DataStoreConsensusCaller(ConsensusCaller caller, PhredQuality defaultQuality) {
            super(caller);
            this.defaultQuality = defaultQuality.getQualityScore();
        }

        @Override
        protected QualitySequence getQualitySequenceFor(DataStoreEntry<NucleotideSequence> read) {
            int length = this.getLength(read);
            byte[] array = new byte[length];
            Arrays.fill(array, this.defaultQuality);
            return new QualitySequenceBuilder(array).turnOffDataCompression(true).build();
        }

        @Override
        protected NucleotideSequence getSequenceFor(DataStoreEntry<NucleotideSequence> read) {
            return read.getValue();
        }

        @Override
        protected int getStartOffset(DataStoreEntry<NucleotideSequence> read) {
            return 0;
        }

        @Override
        protected int getLength(DataStoreEntry<NucleotideSequence> read) {
            return (int)read.getValue().getLength();
        }

        @Override
        protected String getId(DataStoreEntry<NucleotideSequence> read) {
            return read.getKey();
        }

        @Override
        protected Direction getDirection(DataStoreEntry<NucleotideSequence> read) {
            return Direction.FORWARD;
        }
    }

    private static abstract class AbstractAssemblyConsensusCollector
    extends AbstractConsensusCollector<AssembledRead> {
        public AbstractAssemblyConsensusCollector(ConsensusCaller caller) {
            super(caller);
        }

        @Override
        protected NucleotideSequence getSequenceFor(AssembledRead read) {
            return read.getNucleotideSequence();
        }

        @Override
        protected int getStartOffset(AssembledRead read) {
            return (int)read.getBegin();
        }

        @Override
        protected int getLength(AssembledRead read) {
            return (int)read.getLength();
        }

        @Override
        protected String getId(AssembledRead read) {
            return read.getId();
        }

        @Override
        protected Direction getDirection(AssembledRead read) {
            return read.getDirection();
        }
    }

    private static class UngappedConverterAssemblyConsensusCollector
    extends AssemblyDataStoreConsensusCollector {
        private final GapQualityValueStrategy strategy;

        public UngappedConverterAssemblyConsensusCollector(ConsensusCaller caller, QualitySequenceDataStore qualities, GapQualityValueStrategy strategy, NucleotideSequence referenceConsensus) {
            super(caller, qualities, referenceConsensus);
            this.strategy = strategy;
        }

        @Override
        protected QualitySequence toGappedQualitySequence(AssembledRead read, QualitySequence rawQualities) {
            return this.strategy.getGappedValidRangeQualitySequenceFor(read, rawQualities);
        }
    }
}

