/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.consensus.AbstractChurchillWatermanConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusProbabilities;
import org.jcvi.jillion.assembly.util.consensus.ConsensusUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;

public class ConicConsensusCaller
extends AbstractChurchillWatermanConsensusCaller {
    private final double lowerlimit;
    private final double upperlimit;
    private static final double MAX_EFFECTIVE_ANGLE = 45.0;
    public static final double DEFAULT_CONIC_AMBIGUITY_ANGLE = 36.8698977;

    public ConicConsensusCaller(PhredQuality highQualityThreshold) {
        this(highQualityThreshold, 36.8698977);
    }

    public ConicConsensusCaller(PhredQuality highQualityThreshold, double ambiguityAngle) {
        super(highQualityThreshold);
        if (ambiguityAngle < 0.0 || ambiguityAngle > 45.0) {
            throw new IllegalArgumentException("angle must be between 0 and 45");
        }
        double effectiveAngle = this.computeEffectiveAngle(ambiguityAngle);
        double lowerRadians = this.computeLowerRadians(effectiveAngle);
        double upperRadians = this.computeUpperRadians(effectiveAngle);
        this.lowerlimit = Math.tan(lowerRadians);
        this.upperlimit = Math.tan(upperRadians);
    }

    private double computeLowerRadians(double angle) {
        return Math.toRadians(45.0 - angle);
    }

    private double computeUpperRadians(double angle) {
        return Math.toRadians(45.0 + angle);
    }

    private double computeEffectiveAngle(double ambiguityAngle) {
        return Math.min(45.0, ambiguityAngle / 2.0);
    }

    private Set<Nucleotide> getBasesUsedTowardsAmbiguity(Map<Nucleotide, Integer> qualityValueSumMap, MaxQualityStruct maxQualityStruct) {
        EnumSet<Nucleotide> basesTowardsAmbiguity = EnumSet.noneOf(Nucleotide.class);
        Nucleotide maxQualityBase = maxQualityStruct.base;
        basesTowardsAmbiguity.add(maxQualityBase);
        for (Nucleotide base : ConsensusUtil.BASES_TO_CONSIDER) {
            double tangent;
            if (base == maxQualityBase || !((tangent = qualityValueSumMap.get(base).doubleValue() / (double)maxQualityStruct.sum) < this.upperlimit) || !(tangent > this.lowerlimit)) continue;
            basesTowardsAmbiguity.add(base);
        }
        return basesTowardsAmbiguity;
    }

    private MaxQualityStruct createMaxQualityStruct(Map<Nucleotide, Integer> qualityValueSumMap) {
        int maxQualitySum = 0;
        Nucleotide maxQualityBase = Nucleotide.Gap;
        for (Nucleotide base : ConsensusUtil.BASES_TO_CONSIDER) {
            int qualitySum = qualityValueSumMap.get(base);
            if (qualitySum <= maxQualitySum) continue;
            maxQualitySum = qualitySum;
            maxQualityBase = base;
        }
        return new MaxQualityStruct(maxQualityBase, maxQualitySum);
    }

    @Override
    protected Nucleotide getConsensus(ConsensusProbabilities normalizedConsensusProbabilities, Slice slice) {
        Map<Nucleotide, Integer> qualityValueSumMap = this.generateQualityValueSumMap(slice);
        MaxQualityStruct maxQualityStruct = this.createMaxQualityStruct(qualityValueSumMap);
        Set<Nucleotide> basesTowardsAmbiguity = this.getBasesUsedTowardsAmbiguity(qualityValueSumMap, maxQualityStruct);
        return Nucleotide.getAmbiguityFor(basesTowardsAmbiguity);
    }

    private static class MaxQualityStruct {
        private final int sum;
        private final Nucleotide base;

        public MaxQualityStruct(Nucleotide base, int sum) {
            this.base = base;
            this.sum = sum;
        }
    }
}

