/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util.consensus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.assembly.util.consensus.ConsensusCaller;
import org.jcvi.jillion.assembly.util.consensus.ConsensusProbabilities;
import org.jcvi.jillion.assembly.util.consensus.ConsensusResult;
import org.jcvi.jillion.assembly.util.consensus.ConsensusUtil;
import org.jcvi.jillion.assembly.util.consensus.DefaultConsensusResult;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.util.SingleThreadAdder;

abstract class AbstractChurchillWatermanConsensusCaller
implements ConsensusCaller {
    private final PhredQuality highQualityThreshold;

    public AbstractChurchillWatermanConsensusCaller(PhredQuality highQualityThreshold) {
        if (highQualityThreshold == null) {
            throw new NullPointerException("high quality threshold can not be null");
        }
        this.highQualityThreshold = highQualityThreshold;
    }

    public PhredQuality getHighQualityThreshold() {
        return this.highQualityThreshold;
    }

    protected abstract Nucleotide getConsensus(ConsensusProbabilities var1, Slice var2);

    @Override
    public final ConsensusResult callConsensus(Slice slice) {
        if (slice.getCoverageDepth() == 0) {
            return new DefaultConsensusResult(Nucleotide.Gap, 0);
        }
        Map<Nucleotide, Integer> qualityValueSumMap = this.generateQualityValueSumMap(slice);
        ConsensusProbabilities normalizedErrorProbabilityStruct = this.generateNormalizedProbabilityStruct(qualityValueSumMap);
        Nucleotide consensus = this.getConsensus(normalizedErrorProbabilityStruct, slice);
        return new DefaultConsensusResult(consensus, this.getErrorProbability(normalizedErrorProbabilityStruct, slice));
    }

    protected final Map<Nucleotide, Integer> generateQualityValueSumMap(Slice slice) {
        Map<Nucleotide, SingleThreadAdder> qualityValueSumMap = this.initalizeNucleotideMap();
        for (SliceElement sliceElement : slice) {
            Nucleotide basecall = sliceElement.getBase();
            SingleThreadAdder previousSum = qualityValueSumMap.get(basecall);
            if (previousSum == null) continue;
            previousSum.add(sliceElement.getQuality().getQualityScore());
        }
        EnumMap<Nucleotide, Integer> map = new EnumMap<Nucleotide, Integer>(Nucleotide.class);
        for (Map.Entry<Nucleotide, SingleThreadAdder> entry : qualityValueSumMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().intValue());
        }
        return map;
    }

    private Map<Nucleotide, SingleThreadAdder> initalizeNucleotideMap() {
        EnumMap<Nucleotide, SingleThreadAdder> map = new EnumMap<Nucleotide, SingleThreadAdder>(Nucleotide.class);
        for (Nucleotide glyph : ConsensusUtil.BASES_TO_CONSIDER) {
            map.put(glyph, new SingleThreadAdder(0L));
        }
        return map;
    }

    private int getErrorProbability(ConsensusProbabilities normalizedErrorProbabilityStruct, Slice slice) {
        double normalizedProbability = this.getProbabilityFor(normalizedErrorProbabilityStruct);
        if (normalizedProbability == 0.0) {
            int sum = 0;
            for (SliceElement element : slice) {
                sum += element.getQuality().getQualityScore();
            }
            return sum;
        }
        return PhredQuality.computeQualityScore(normalizedProbability);
    }

    private double getProbabilityFor(ConsensusProbabilities normalizedErrorProbabilityStruct) {
        Double lowest = Double.MAX_VALUE;
        for (Map.Entry<Nucleotide, Double> entry : normalizedErrorProbabilityStruct.entrySet()) {
            Double currentValue = entry.getValue();
            if (currentValue.compareTo(lowest) >= 0) continue;
            lowest = currentValue;
        }
        if (lowest.equals(Double.MAX_VALUE)) {
            return 0.0;
        }
        return lowest;
    }

    private ConsensusProbabilities generateNormalizedProbabilityStruct(Map<Nucleotide, Integer> qualityValueSumMap) {
        List<ConsensusProbabilities> probabilityStructs = this.createProbabilityStructsForEachBase(qualityValueSumMap);
        ConsensusProbabilities rawErrorProbabilityStruct = this.createRawErrorProbabilityStruct(probabilityStructs);
        return rawErrorProbabilityStruct.normalize();
    }

    private ConsensusProbabilities createRawErrorProbabilityStruct(List<ConsensusProbabilities> probabilityStructs) {
        EnumMap<Nucleotide, Double> rawErrorProbabilityMap = new EnumMap<Nucleotide, Double>(Nucleotide.class);
        for (Nucleotide base : ConsensusUtil.BASES_TO_CONSIDER) {
            rawErrorProbabilityMap.put(base, this.calculateRawErrorProbabilityFor(base, probabilityStructs));
        }
        return new ConsensusProbabilities(rawErrorProbabilityMap);
    }

    private List<ConsensusProbabilities> createProbabilityStructsForEachBase(Map<Nucleotide, Integer> qualityValueSumMap) {
        ArrayList<ConsensusProbabilities> probabilityStructs = new ArrayList<ConsensusProbabilities>();
        for (Nucleotide base : ConsensusUtil.BASES_TO_CONSIDER) {
            probabilityStructs.add(new ConsensusProbabilities(base, qualityValueSumMap.get(base)));
        }
        return probabilityStructs;
    }

    private double calculateRawErrorProbabilityFor(Nucleotide base, List<ConsensusProbabilities> probabilityStructs) {
        double result = 1.0;
        for (ConsensusProbabilities struct : probabilityStructs) {
            result *= struct.getProbabilityFor(base).doubleValue();
        }
        return result;
    }

    protected final Set<Nucleotide> getBasesUsedTowardsAmbiguity(ConsensusProbabilities normalizedErrorProbabilityStruct, int baseCount) {
        double errorProbabilityOfAmbiguity;
        double sumOfProbabilitySuccess = 0.0;
        EnumSet<Nucleotide> basesUsed = EnumSet.noneOf(Nucleotide.class);
        ArrayList<Nucleotide> basesToConsider = new ArrayList<Nucleotide>(ConsensusUtil.BASES_TO_CONSIDER);
        Collections.sort(basesToConsider, new LowestProbabilityComparator(normalizedErrorProbabilityStruct));
        do {
            Nucleotide baseWithLowestErrorProbability = (Nucleotide)basesToConsider.remove(0);
            basesUsed.add(baseWithLowestErrorProbability);
            errorProbabilityOfAmbiguity = 1.0 - (sumOfProbabilitySuccess += 1.0 - normalizedErrorProbabilityStruct.getProbabilityFor(baseWithLowestErrorProbability));
        } while (sumOfProbabilitySuccess < 1.0 && this.underThreshold(errorProbabilityOfAmbiguity) && basesUsed.size() < baseCount);
        return basesUsed;
    }

    private boolean underThreshold(double errorProbability) {
        return PhredQuality.computeQualityScore(errorProbability) < this.getHighQualityThreshold().getQualityScore();
    }

    private static class LowestProbabilityComparator
    implements Comparator<Nucleotide> {
        private final ConsensusProbabilities probabilityStruct;

        LowestProbabilityComparator(ConsensusProbabilities probabilityStruct) {
            this.probabilityStruct = probabilityStruct;
        }

        @Override
        public int compare(Nucleotide o1, Nucleotide o2) {
            return this.probabilityStruct.getProbabilityFor(o1).compareTo(this.probabilityStruct.getProbabilityFor(o2));
        }
    }
}

