/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceCombiner;
import org.jcvi.jillion.assembly.util.SliceMap;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.ArrayIterator;

public final class SliceMapCollector
implements Collector<AssembledRead, SliceCombiner, SliceMap> {
    private static final Set<Collector.Characteristics> UNORDERED_AND_CONCURRENT = EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT);
    private static final PhredQuality DEFAULT_QUALITY = PhredQuality.valueOf(30);
    private final NucleotideSequence consensus;
    private final QualitySequenceDataStore qualityDataStore;
    private final GapQualityValueStrategy qualityValueStrategy;
    private final PhredQuality defaultQuality;

    public static SliceMapCollector toSliceMap(NucleotideSequence consensus) {
        return SliceMapCollector.toSliceMap(consensus, GapQualityValueStrategy.LOWEST_FLANKING, DEFAULT_QUALITY);
    }

    public static SliceMapCollector toSliceMap(NucleotideSequence consensus, GapQualityValueStrategy qualityValueStrategy) {
        return SliceMapCollector.toSliceMap(consensus, qualityValueStrategy, DEFAULT_QUALITY);
    }

    public static SliceMapCollector toSliceMap(NucleotideSequence consensus, GapQualityValueStrategy qualityValueStrategy, PhredQuality defaultQuality) {
        return SliceMapCollector.toSliceMap(consensus, qualityValueStrategy, null, DEFAULT_QUALITY);
    }

    public static SliceMapCollector toSliceMap(NucleotideSequence consensus, GapQualityValueStrategy qualityValueStrategy, QualitySequenceDataStore qualities) {
        return SliceMapCollector.toSliceMap(consensus, qualityValueStrategy, qualities, DEFAULT_QUALITY);
    }

    public static SliceMapCollector toSliceMap(NucleotideSequence consensus, GapQualityValueStrategy qualityValueStrategy, QualitySequenceDataStore qualities, PhredQuality defaultQuality) {
        return new SliceMapCollector(consensus, qualities, qualityValueStrategy, defaultQuality);
    }

    private SliceMapCollector(NucleotideSequence consensus, QualitySequenceDataStore qualityDataStore, GapQualityValueStrategy qualityValueStrategy, PhredQuality defaultQuality) {
        this.consensus = consensus;
        this.qualityDataStore = qualityDataStore;
        this.qualityValueStrategy = qualityValueStrategy;
        this.defaultQuality = defaultQuality;
    }

    @Override
    public Supplier<SliceCombiner> supplier() {
        return () -> new SliceCombiner((int)this.consensus.getLength());
    }

    @Override
    public BiConsumer<SliceCombiner, AssembledRead> accumulator() {
        return this::addRead;
    }

    private void addRead(SliceCombiner combiner, AssembledRead read) {
        int start = (int)read.getGappedStartOffset();
        String id = read.getId();
        Direction dir = read.getDirection();
        Iterator<PhredQuality> validRangeGappedQualitiesIterator = null;
        if (this.qualityDataStore == null) {
            validRangeGappedQualitiesIterator = this.createNewDefaultQualityIterator(this.defaultQuality);
        } else {
            QualitySequence fullQualities;
            try {
                fullQualities = (QualitySequence)this.qualityDataStore.get(id);
            }
            catch (DataStoreException e) {
                throw new RuntimeException("error processing quality data for " + id);
            }
            if (fullQualities == null) {
                throw new NullPointerException("could not get qualities for " + id);
            }
            validRangeGappedQualitiesIterator = this.qualityValueStrategy.getGappedValidRangeQualitySequenceFor(read, fullQualities).iterator();
        }
        combiner.add(id, start, read.getNucleotideSequence(), validRangeGappedQualitiesIterator, dir);
    }

    @Override
    public BinaryOperator<SliceCombiner> combiner() {
        return (a, b) -> a.combine((SliceCombiner)b);
    }

    @Override
    public Function<SliceCombiner, SliceMap> finisher() {
        return this::toSliceMap;
    }

    private SliceMap toSliceMap(SliceCombiner combiner) {
        Slice[] slices = combiner.toSlices(this.consensus);
        return new CollectedSliceMap(slices);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return UNORDERED_AND_CONCURRENT;
    }

    private Iterator<PhredQuality> createNewDefaultQualityIterator(final PhredQuality defaultQuality) {
        return new Iterator<PhredQuality>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            @SuppressFBWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="only used for fake data will never have no such element exception")
            public PhredQuality next() {
                return defaultQuality;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class CollectedSliceMap
    implements SliceMap {
        private final Slice[] slices;

        protected CollectedSliceMap(Slice[] slices) {
            this.slices = slices;
        }

        @Override
        public Iterator<Slice> iterator() {
            return new ArrayIterator<Slice>(this.slices, false);
        }

        @Override
        public Slice getSlice(long offset) {
            return this.slices[(int)offset];
        }

        @Override
        public long getSize() {
            return this.slices.length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.slices);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CollectedSliceMap)) {
                return false;
            }
            CollectedSliceMap other = (CollectedSliceMap)obj;
            return Arrays.equals(this.slices, other.slices);
        }
    }
}

