/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.io.Closeable;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.util.GapQualityValueStrategy;
import org.jcvi.jillion.assembly.util.SliceMap;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequenceDataStore;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.assembly.util.CompactedSliceMap;

public final class SliceMapBuilder<R extends AssembledRead>
implements Builder<SliceMap> {
    private final Contig<R> contig;
    private QualitySequenceDataStore qualities;
    private PhredQuality defaultQuality;
    private GapQualityValueStrategy qualityValueStrategy = GapQualityValueStrategy.LOWEST_FLANKING;
    private Predicate<? super R> filter = null;

    public SliceMapBuilder(Contig<R> contig, PhredQuality defaultQuality) {
        if (contig == null) {
            throw new NullPointerException("contig can not be null");
        }
        if (defaultQuality == null) {
            throw new NullPointerException("defaultQuality can not be null");
        }
        this.contig = contig;
        this.defaultQuality = defaultQuality;
    }

    public SliceMapBuilder(Contig<R> contig, QualitySequenceDataStore readQualities) {
        if (contig == null) {
            throw new NullPointerException("contig can not be null");
        }
        if (readQualities == null) {
            throw new NullPointerException("readQualities can not be null");
        }
        this.contig = contig;
        this.qualities = readQualities;
    }

    public SliceMapBuilder<R> gapQualityValueStrategy(GapQualityValueStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("GapQualityValueStrategies can not be null");
        }
        this.qualityValueStrategy = strategy;
        return this;
    }

    public SliceMapBuilder<R> filter(Predicate<? super R> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    @Override
    public SliceMap build() {
        CompactedSliceMap compactedSliceMap;
        FilteredIterator iter;
        block5: {
            iter = null;
            iter = this.filter == null ? this.contig.getReadIterator() : new FilteredIterator(this.contig.getReadIterator());
            if (this.qualities != null) break block5;
            CompactedSliceMap compactedSliceMap2 = CompactedSliceMap.create(iter, this.contig.getConsensusSequence(), this.defaultQuality, this.qualityValueStrategy);
            IOUtil.closeAndIgnoreErrors((Closeable)iter);
            return compactedSliceMap2;
        }
        try {
            compactedSliceMap = CompactedSliceMap.create(iter, this.contig.getConsensusSequence(), this.qualities, this.qualityValueStrategy);
        }
        catch (DataStoreException e) {
            try {
                throw new IllegalStateException("error building SliceMap", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(iter);
                throw throwable;
            }
        }
        IOUtil.closeAndIgnoreErrors((Closeable)iter);
        return compactedSliceMap;
    }

    private class FilteredIterator
    implements StreamingIterator<R> {
        private final Object endToken = new Object();
        private final StreamingIterator<R> delegate;
        private Object current;

        public FilteredIterator(StreamingIterator<R> delegate) {
            this.delegate = delegate;
            this.updateCurrent();
        }

        private void updateCurrent() {
            this.current = this.endToken;
            while (this.delegate.hasNext()) {
                AssembledRead next = (AssembledRead)this.delegate.next();
                if (!SliceMapBuilder.this.filter.test(next)) continue;
                this.current = next;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != this.endToken;
        }

        @Override
        public void close() {
            this.current = this.endToken;
            this.delegate.close();
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AssembledRead ret = (AssembledRead)this.current;
            this.updateCurrent();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

