/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.Arrays;
import java.util.Iterator;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceBuilder;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

final class SliceCombiner {
    private final SliceBuilder[] builders;

    public SliceCombiner(int size) {
        this.builders = new SliceBuilder[size];
        Arrays.parallelSetAll(this.builders, i -> new SliceBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String id, int start, NucleotideSequence seq, Iterator<PhredQuality> qualities, Direction dir) {
        int i = 0;
        for (Nucleotide base : seq) {
            SliceBuilder builder;
            PhredQuality quality = qualities.next();
            SliceBuilder sliceBuilder = builder = this.builders[start + i];
            synchronized (sliceBuilder) {
                builder.addNew(id, base, quality, dir);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SliceCombiner combine(SliceCombiner other) {
        for (int i = 0; i < this.builders.length; ++i) {
            SliceBuilder myBuilder;
            SliceBuilder otherBuilder = other.builders[i];
            if (otherBuilder.isEmpty()) continue;
            SliceBuilder sliceBuilder = myBuilder = this.builders[i];
            synchronized (sliceBuilder) {
                myBuilder.mergeNew(otherBuilder);
                continue;
            }
        }
        return this;
    }

    public synchronized Slice[] toSlices(NucleotideSequence consensus) {
        Slice[] ret = new Slice[this.builders.length];
        int i = 0;
        for (Nucleotide n : consensus) {
            ret[i] = this.builders[i].setConsensus(n).build();
            ++i;
        }
        return ret;
    }
}

