/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.ArrayList;
import java.util.List;
import org.jcvi.jillion.assembly.util.Slice;
import org.jcvi.jillion.assembly.util.SliceElement;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.residue.nt.Nucleotide;
import org.jcvi.jillion.core.util.Builder;
import org.jcvi.jillion.internal.assembly.util.CompactedSliceElement;
import org.jcvi.jillion.internal.assembly.util.ConsensusCompactedSlice;
import org.jcvi.jillion.internal.assembly.util.NoConsensusCompactedSlice;
import org.jcvi.jillion.internal.core.util.GrowableShortArray;

public final class SliceBuilder
implements Builder<Slice> {
    private GrowableShortArray bytes = new GrowableShortArray(1024);
    private List<String> ids = new ArrayList<String>();
    private Nucleotide consensus;

    public SliceBuilder() {
    }

    public SliceBuilder(Nucleotide consensus) {
        this.setConsensus(consensus);
    }

    public SliceBuilder(Slice slice) {
        if (slice == null) {
            throw new NullPointerException("Slice can not be null");
        }
        this.addAll(slice);
        this.setConsensus(slice.getConsensusCall());
    }

    public SliceBuilder(Slice slice, SliceElementFilter filter) {
        if (slice == null) {
            throw new NullPointerException("Slice can not be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        for (SliceElement e : slice) {
            if (!filter.accept(e)) continue;
            this.add(e);
        }
        this.setConsensus(slice.getConsensusCall());
    }

    public SliceBuilder filter(SliceElementFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        GrowableShortArray newBytes = new GrowableShortArray(this.bytes.getCurrentLength());
        ArrayList<String> newIds = new ArrayList<String>(this.ids.size());
        for (int i = 0; i < this.ids.size(); ++i) {
            short value;
            String id = this.ids.get(i);
            if (!filter.accept(CompactedSliceElement.create(id, value = this.bytes.get(i)))) continue;
            newBytes.append(value);
            newIds.add(id);
        }
        this.ids = newIds;
        this.bytes = newBytes;
        return this;
    }

    public SliceBuilder(Iterable<? extends SliceElement> elements) {
        if (elements == null) {
            throw new NullPointerException("Slice can not be null");
        }
        this.addAll(elements);
    }

    public int getCurrentCoverageDepth() {
        return this.ids.size();
    }

    private SliceBuilder(SliceBuilder copy) {
        this.ids = new ArrayList<String>(copy.ids);
        this.bytes = copy.bytes.copy();
        this.consensus = copy.consensus;
    }

    public SliceBuilder setConsensus(Nucleotide consensus) {
        this.consensus = consensus;
        return this;
    }

    public SliceBuilder add(SliceElement element) {
        if (element == null) {
            throw new NullPointerException("SliceElement can not be nul");
        }
        return this.add(element.getId(), element.getBase(), element.getQuality(), element.getDirection());
    }

    public SliceBuilder addAll(Iterable<? extends SliceElement> elements) {
        for (SliceElement sliceElement : elements) {
            this.add(sliceElement);
        }
        return this;
    }

    public SliceBuilder addAll(SliceBuilder other) {
        other.addTo(this);
        return this;
    }

    protected void addTo(SliceBuilder sliceBuilder) {
        for (SliceElement e : this.build()) {
            sliceBuilder.add(e);
        }
    }

    protected void mergeNew(SliceBuilder other) {
        this.ids.addAll(other.ids);
        this.bytes.append(other.bytes);
    }

    public SliceBuilder add(String id, Nucleotide base, PhredQuality quality, Direction dir) {
        CompactedSliceElement compacted = new CompactedSliceElement(id, base, quality, dir);
        int value = compacted.getEncodedDirAndNucleotide() << 8;
        value |= compacted.getEncodedQuality() & 0xFF;
        int index = this.ids.indexOf(id);
        if (index == -1) {
            this.bytes.append((short)value);
            this.ids.add(id);
        } else {
            this.bytes.replace(index, (short)value);
        }
        return this;
    }

    SliceBuilder addNew(String id, Nucleotide base, PhredQuality quality, Direction dir) {
        CompactedSliceElement compacted = new CompactedSliceElement(id, base, quality, dir);
        int value = compacted.getEncodedDirAndNucleotide() << 8;
        this.bytes.append((short)(value |= compacted.getEncodedQuality() & 0xFF));
        this.ids.add(id);
        return this;
    }

    public boolean containsId(String id) {
        if (id == null) {
            throw new NullPointerException("id can not be null");
        }
        return this.ids.contains(id);
    }

    public SliceBuilder removeById(String id) {
        int index = this.ids.indexOf(id);
        if (index != -1) {
            this.ids.remove(index);
            this.bytes.remove(index);
        }
        return this;
    }

    public SliceBuilder copy() {
        return new SliceBuilder(this);
    }

    @Override
    public Slice build() {
        if (this.consensus == null) {
            return new NoConsensusCompactedSlice(this.bytes.toArray(), this.ids);
        }
        return new ConsensusCompactedSlice(this.bytes.toArray(), this.ids, this.consensus);
    }

    public String toString() {
        return "SliceBuilder [bytes=" + this.bytes + ", ids=" + this.ids + ", consensus=" + this.consensus + "]";
    }

    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    public static interface SliceElementFilter {
        public boolean accept(SliceElement var1);
    }
}

