/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.List;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.qual.PhredQuality;
import org.jcvi.jillion.core.qual.QualitySequence;
import org.jcvi.jillion.core.qual.QualitySequenceBuilder;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;

public enum GapQualityValueStrategy {
    LOWEST_FLANKING{

        @Override
        protected PhredQuality computeQualityValueForGap(PhredQuality leftFlankingQuality, PhredQuality rightFlankingQuality) {
            if (leftFlankingQuality.compareTo(rightFlankingQuality) < 0) {
                return leftFlankingQuality;
            }
            return rightFlankingQuality;
        }
    }
    ,
    ALWAYS_ZERO{

        @Override
        protected PhredQuality computeQualityValueForGap(PhredQuality leftFlankingQuality, PhredQuality rightFlankingQuality) {
            return PhredQuality.valueOf(0);
        }
    };


    public QualitySequence getGappedValidRangeQualitySequenceFor(NucleotideSequence validRangeSequence, QualitySequence rawQualities, Range validRange, Direction direction) {
        QualitySequenceBuilder complementedRawQualities = new QualitySequenceBuilder(rawQualities);
        QualitySequenceBuilder gappedValidRangeQualities = complementedRawQualities.copy().trim(validRange);
        if (direction == Direction.REVERSE) {
            gappedValidRangeQualities.reverse();
            complementedRawQualities.reverse();
        }
        List<Integer> gapOffsets = validRangeSequence.getGapOffsets();
        int rawShiftOffset = (int)validRange.getBegin();
        for (Integer gapOffset : gapOffsets) {
            int offset = gapOffset;
            int leftFlank = validRangeSequence.getUngappedOffsetFor(offset);
            int rightFlank = leftFlank + 1;
            PhredQuality leftQuality = complementedRawQualities.get(rawShiftOffset + leftFlank);
            PhredQuality rightQuality = complementedRawQualities.get(rawShiftOffset + rightFlank);
            PhredQuality gappedQuality = this.computeQualityValueForGap(leftQuality, rightQuality);
            gappedValidRangeQualities.insert(offset, gappedQuality);
        }
        return gappedValidRangeQualities.build();
    }

    public QualitySequence getGappedValidRangeQualitySequenceFor(AssembledRead read, QualitySequence rawQualities) {
        if (read == null) {
            throw new NullPointerException("read can not be null");
        }
        if (rawQualities == null) {
            throw new NullPointerException("qualities can not be null");
        }
        return this.getGappedValidRangeQualitySequenceFor(read.getNucleotideSequence(), rawQualities, read.getReadInfo().getValidRange(), read.getDirection());
    }

    protected abstract PhredQuality computeQualityValueForGap(PhredQuality var1, PhredQuality var2);

    protected PhredQuality getQualityForNonGapBase(AssembledRead placedRead, QualitySequence uncomplementedQualities, int gappedReadIndexForNonGapBase) {
        int ungappedFullRangeIndex = AssemblyUtil.convertToUngappedFullRangeOffset(placedRead, gappedReadIndexForNonGapBase);
        return (PhredQuality)uncomplementedQualities.get(ungappedFullRangeIndex);
    }
}

