/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;
import org.jcvi.jillion.assembly.util.CoverageRegion;
import org.jcvi.jillion.assembly.util.CoverageRegionBuilder;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.util.MapUtil;

final class DefaultCoverageRegion<T extends Rangeable>
implements CoverageRegion<T> {
    private final Collection<T> elements;
    private final Range range;

    private DefaultCoverageRegion(Range range, Collection<T> elements) {
        this.elements = elements;
        this.range = range;
    }

    @Override
    public int getCoverageDepth() {
        return this.elements.size();
    }

    @Override
    public Stream<T> streamElements() {
        return this.elements.stream();
    }

    @Override
    public long getLength() {
        return this.range.getLength();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public String toString() {
        return new StringBuilder(50).append("coverage region : ").append(this.range).append(" coverage = ").append(this.getCoverageDepth()).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.range.hashCode();
        result = 31 * result + new HashSet<T>(this.elements).hashCode();
        return result;
    }

    private boolean elementsAreEqual(CoverageRegion<?> otherRegion) {
        int otherDepth = otherRegion.getCoverageDepth();
        if (otherDepth != this.elements.size()) {
            return false;
        }
        HashSet set = new HashSet(MapUtil.computeMinHashMapSizeWithoutRehashing(otherDepth));
        Iterator otherIterator = otherRegion.iterator();
        while (otherIterator.hasNext()) {
            set.add(otherIterator.next());
        }
        return new HashSet<T>(this.elements).equals(set);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CoverageRegion)) {
            return false;
        }
        CoverageRegion other = (CoverageRegion)obj;
        return this.range.equals(other.asRange()) && this.elementsAreEqual(other);
    }

    @Override
    public Range asRange() {
        return this.range;
    }

    static final class Builder<T extends Rangeable>
    implements CoverageRegionBuilder<T> {
        private long start;
        private long end;
        private Queue<T> elements;
        private boolean endIsSet;

        @Override
        public boolean isEndIsSet() {
            return this.endIsSet;
        }

        public Builder(long start, Iterable<T> elements) {
            this(start, elements, null);
        }

        public Builder(long start, Iterable<T> elements, Integer maxAllowedCoverage) {
            this(start, elements == null ? null : elements.iterator(), maxAllowedCoverage);
        }

        private Builder(long start, Iterator<T> elements, Integer maxAllowedCoverage) {
            if (elements == null) {
                throw new IllegalArgumentException("elements can not be null");
            }
            this.start = start;
            this.elements = maxAllowedCoverage == null ? new ArrayDeque<T>() : new ArrayBlockingQueue<T>(maxAllowedCoverage);
            while (elements.hasNext()) {
                this.elements.offer(elements.next());
            }
        }

        @Override
        public Builder<T> shift(long shift) {
            this.start += shift;
            this.end += shift;
            return this;
        }

        @Override
        public long start() {
            return this.start;
        }

        @Override
        public boolean canSetEndTo(long end) {
            return end >= this.start - 1L;
        }

        @Override
        public long end() {
            if (!this.isEndIsSet()) {
                throw new IllegalArgumentException("end not yet set");
            }
            return this.end;
        }

        @Override
        public Builder<T> end(long end) {
            if (!this.canSetEndTo(end)) {
                throw new IllegalArgumentException("end must be >= than " + (this.start + 1L) + " but was " + end);
            }
            this.end = end;
            this.endIsSet = true;
            return this;
        }

        @Override
        public Builder<T> add(T element) {
            this.elements.offer(element);
            return this;
        }

        @Override
        public boolean offer(T element) {
            return this.elements.offer(element);
        }

        @Override
        public Builder<T> remove(T element) {
            this.elements.remove(element);
            return this;
        }

        @Override
        public Builder<T> removeAll(Collection<T> elements) {
            this.elements.removeAll(elements);
            return this;
        }

        @Override
        public DefaultCoverageRegion<T> build() {
            if (!this.endIsSet) {
                throw new IllegalStateException("end must be set");
            }
            return new DefaultCoverageRegion(Range.of(this.start, this.end), this.elements);
        }

        @Override
        public Collection<T> getElements() {
            return new ArrayList<T>(this.elements);
        }

        @Override
        public int getCurrentCoverageDepth() {
            return this.elements.size();
        }

        @Override
        public boolean hasSameElementsAs(CoverageRegionBuilder<T> other) {
            if (other == null) {
                return false;
            }
            if (this.elements.size() != other.getCurrentCoverageDepth()) {
                return false;
            }
            return this.elements.containsAll(other.getElements());
        }

        @Override
        public Range asRange() {
            return Range.of(this.start, this.end);
        }

        @Override
        public boolean rangeIsEmpty() {
            return this.end == this.start - 1L;
        }

        @Override
        public void forceAdd(T element) {
            try {
                this.elements.add(element);
            }
            catch (IllegalStateException e) {
                this.elements = new ArrayDeque<T>(this.elements);
                this.elements.add(element);
            }
        }
    }
}

