/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import org.jcvi.jillion.assembly.util.CoverageMapStats;
import org.jcvi.jillion.assembly.util.CoverageRegion;

public class CoverageStatsCombiner {
    LongAccumulator minCoverage = new LongAccumulator((current, min) -> current < min ? current : min, Integer.MAX_VALUE);
    LongAccumulator maxCoverage = new LongAccumulator((current, min) -> current > min ? current : min, Integer.MIN_VALUE);
    LongAdder totalLength = new LongAdder();
    LongAdder totalCoverage = new LongAdder();

    public CoverageStatsCombiner add(CoverageRegion<?> region) {
        long regionLength = region.getLength();
        this.totalLength.add(regionLength);
        int coverageDepth = region.getCoverageDepth();
        this.totalCoverage.add((long)coverageDepth * regionLength);
        this.minCoverage.accumulate(coverageDepth);
        this.maxCoverage.accumulate(coverageDepth);
        return this;
    }

    public CoverageStatsCombiner merge(CoverageStatsCombiner other) {
        this.totalLength.add(other.totalLength.longValue());
        this.totalCoverage.add(other.totalCoverage.longValue());
        this.minCoverage.accumulate(other.minCoverage.intValue());
        this.maxCoverage.accumulate(other.maxCoverage.intValue());
        return this;
    }

    public CoverageMapStats build() {
        long totalLength = this.totalLength.longValue();
        if (totalLength == 0L) {
            return new CoverageMapStats(0, 0, 0.0);
        }
        return new CoverageMapStats(this.minCoverage.intValue(), this.maxCoverage.intValue(), (double)this.totalCoverage.longValue() / this.totalLength.doubleValue());
    }
}

