/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

public final class CoverageMapStats {
    private final int minCoverage;
    private final int maxCoverage;
    private final double avgCoverage;

    public CoverageMapStats(int minCoverage, int maxCoverage, double avgCoverage) {
        this.minCoverage = minCoverage;
        this.maxCoverage = maxCoverage;
        this.avgCoverage = avgCoverage;
    }

    public int getMinCoverage() {
        return this.minCoverage;
    }

    public int getMaxCoverage() {
        return this.maxCoverage;
    }

    public double getAvgCoverage() {
        return this.avgCoverage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.avgCoverage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxCoverage;
        result = 31 * result + this.minCoverage;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageMapStats)) {
            return false;
        }
        CoverageMapStats other = (CoverageMapStats)obj;
        if (Double.doubleToLongBits(this.avgCoverage) != Double.doubleToLongBits(other.avgCoverage)) {
            return false;
        }
        if (this.maxCoverage != other.maxCoverage) {
            return false;
        }
        return this.minCoverage == other.minCoverage;
    }

    public String toString() {
        return "CoverageMapStats [minCoverage=" + this.minCoverage + ", maxCoverage=" + this.maxCoverage + ", avgCoverage=" + this.avgCoverage + "]";
    }
}

