/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssemblyUtil;
import org.jcvi.jillion.assembly.util.AbstractCoverageMapBuilder;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapCollectors;
import org.jcvi.jillion.assembly.util.CoverageMapStats;
import org.jcvi.jillion.assembly.util.CoverageRegion;
import org.jcvi.jillion.assembly.util.CoverageRegionBuilder;
import org.jcvi.jillion.assembly.util.DefaultCoverageRegion;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.iter.ArrayIterator;
import org.jcvi.jillion.core.util.iter.IteratorUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

final class CoverageMapFactory {
    public static <R extends Rangeable> CoverageMap<R> create(Collection<R> elements) {
        return new Builder<R>(elements).build();
    }

    public static <R extends Rangeable> CoverageMap<R> create(Collection<R> elements, boolean startAtOrigin) {
        return new Builder<R>(elements, startAtOrigin).build();
    }

    public static <R extends Rangeable> CoverageMap<R> create(Collection<R> elements, int maxAllowedCoverage) {
        return new Builder<R>(elements, maxAllowedCoverage, false).build();
    }

    public static <R extends Rangeable> CoverageMap<R> create(Collection<R> elements, int maxAllowedCoverage, boolean startAtOrigin) {
        return new Builder<R>(elements, maxAllowedCoverage, startAtOrigin).build();
    }

    public static <R extends Rangeable> CoverageMap<R> create(Collection<R> elements, int maxAllowedCoverage, int minRequiredCoverage) {
        return CoverageMapFactory.create(elements, maxAllowedCoverage, minRequiredCoverage, false);
    }

    public static <R extends Rangeable> CoverageMap<R> create(Collection<R> elements, int maxAllowedCoverage, int minRequiredCoverage, boolean startAtOrigin) {
        return new Builder<R>(elements, maxAllowedCoverage, minRequiredCoverage, startAtOrigin).build();
    }

    public static <R extends AssembledRead> CoverageMap<R> createUngappedCoverageMap(NucleotideSequence consensus, CoverageMap<R> gappedCoverageMap) {
        ArrayList<Object> ungappedCoverageRegions = new ArrayList<Object>();
        for (CoverageRegion coverageRegion : gappedCoverageMap) {
            Range gappedRange = coverageRegion.asRange();
            Range ungappedRange = AssemblyUtil.toUngappedRange(consensus, gappedRange);
            ArrayList<AssembledRead> reads = new ArrayList<AssembledRead>(coverageRegion.getCoverageDepth());
            for (AssembledRead read : coverageRegion) {
                reads.add(read);
            }
            ungappedCoverageRegions.add(((DefaultCoverageRegion.Builder)new DefaultCoverageRegion.Builder(ungappedRange.getBegin(), reads).end(ungappedRange.getEnd())).build());
        }
        return new CoverageMapImpl(ungappedCoverageRegions);
    }

    private CoverageMapFactory() {
    }

    private static class Builder<P extends Rangeable>
    extends AbstractCoverageMapBuilder<P> {
        private final List<P> startCoordinateSortedList = new ArrayList<P>();
        private final List<P> endCoordinateSortedList = new ArrayList<P>();
        private final boolean startAtOrigin;

        public Builder(Collection<P> elements, int maxAllowedCoverage, boolean startAtOrigin) {
            super(maxAllowedCoverage);
            this.initialize(elements);
            this.startAtOrigin = startAtOrigin;
        }

        public Builder(Collection<P> elements, int maxAllowedCoverage, int minRequiredCoverage, boolean startAtOrigin) {
            super(maxAllowedCoverage, minRequiredCoverage);
            this.initialize(elements);
            this.startAtOrigin = startAtOrigin;
        }

        public Builder(Collection<P> elements, boolean startAtOrigin) {
            this.initialize(elements);
            this.startAtOrigin = startAtOrigin;
        }

        public Builder(Collection<P> elements) {
            this(elements, false);
        }

        private final void initialize(Collection<P> collection) {
            this.initialize(IteratorUtil.createStreamingIterator(collection.iterator()));
        }

        private final void initialize(StreamingIterator<P> elements) {
            try {
                while (elements.hasNext()) {
                    Rangeable element = (Rangeable)elements.next();
                    this.startCoordinateSortedList.add(element);
                    this.endCoordinateSortedList.add(element);
                }
            }
            finally {
                IOUtil.closeAndIgnoreErrors(elements);
            }
            this.filterAmpliconsWithoutCoordinates(this.startCoordinateSortedList);
            this.filterAmpliconsWithoutCoordinates(this.endCoordinateSortedList);
            Collections.sort(this.startCoordinateSortedList, new RangeableStartComparator());
            Collections.sort(this.endCoordinateSortedList, new RangeableEndComparator());
        }

        private void filterAmpliconsWithoutCoordinates(Collection<P> amp) {
            Iterator<P> it = amp.iterator();
            while (it.hasNext()) {
                Rangeable entry = (Rangeable)it.next();
                if (entry.asRange().getLength() != 0L) continue;
                it.remove();
            }
        }

        @Override
        protected CoverageRegionBuilder<P> createNewCoverageRegionBuilder(Collection<P> elements, long start, Integer maxAllowedCoverage) {
            return new DefaultCoverageRegion.Builder<P>(start, elements, maxAllowedCoverage);
        }

        private List<CoverageRegion<P>> buildAllCoverageRegions(List<CoverageRegionBuilder<P>> coverageRegionBuilders) {
            if (coverageRegionBuilders.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<CoverageRegion<P>> regions = new ArrayList<CoverageRegion<P>>(coverageRegionBuilders.size() + 1);
            DefaultCoverageRegion.Builder newFirst = null;
            DefaultCoverageRegion.Builder newLast = null;
            if (this.startAtOrigin) {
                long firstStart = coverageRegionBuilders.get(0).start();
                if (firstStart < 0L) {
                    long lastCoveredOffset = coverageRegionBuilders.get(coverageRegionBuilders.size() - 1).end();
                    if (lastCoveredOffset < 0L) {
                        newLast = new DefaultCoverageRegion.Builder(lastCoveredOffset + 1L, Collections.emptyList());
                        newLast.end(0L);
                    }
                } else if (firstStart > 0L) {
                    newFirst = new DefaultCoverageRegion.Builder(0L, Collections.emptyList());
                    newFirst.end(firstStart - 1L);
                }
            }
            if (newFirst != null) {
                regions.add((CoverageRegion<P>)newFirst.build());
            }
            Iterator<CoverageRegionBuilder<P>> iterator = coverageRegionBuilders.iterator();
            while (iterator.hasNext()) {
                regions.add((CoverageRegion<P>)iterator.next().build());
            }
            if (newLast != null) {
                regions.add((CoverageRegion<P>)newLast.build());
            }
            return regions;
        }

        @Override
        protected CoverageMap<P> build(List<CoverageRegionBuilder<P>> coverageRegionBuilders) {
            return new CoverageMapImpl(this.buildAllCoverageRegions(coverageRegionBuilders));
        }

        @Override
        protected Iterator<P> createEnteringIterator() {
            return this.startCoordinateSortedList.iterator();
        }

        @Override
        protected Iterator<P> createLeavingIterator() {
            return this.endCoordinateSortedList.iterator();
        }
    }

    private static enum CoverageRegionComparators implements Comparator<CoverageRegion<?>>
    {
        BY_BEGIN(new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                long l2;
                long l1 = o1.getBegin();
                if (l1 == (l2 = o2.getBegin())) {
                    return 0;
                }
                if (l1 < l2) {
                    return -1;
                }
                return 1;
            }
        }),
        BY_END(new Comparator<Range>(){

            @Override
            public int compare(Range o1, Range o2) {
                long l2;
                long l1 = o1.getEnd();
                if (l1 == (l2 = o2.getEnd())) {
                    return 0;
                }
                if (l1 < l2) {
                    return -1;
                }
                return 1;
            }
        });

        private final Comparator<Range> rangeComparator;

        private CoverageRegionComparators(Comparator<Range> comparator) {
            this.rangeComparator = comparator;
        }

        @Override
        public int compare(CoverageRegion<?> o1, CoverageRegion<?> o2) {
            return this.rangeComparator.compare(o1.asRange(), o2.asRange());
        }
    }

    private static final class CoverageMapImpl<V extends Rangeable>
    implements CoverageMap<V> {
        private final CoverageRegion<V>[] regions;
        private CoverageMapStats stats = null;

        private CoverageMapImpl(List<CoverageRegion<V>> regions) {
            this.regions = regions.toArray(new CoverageRegion[regions.size()]);
        }

        @Override
        public int getNumberOfRegions() {
            return this.regions.length;
        }

        @Override
        public CoverageRegion<V> getRegion(int i) {
            return this.regions[i];
        }

        @Override
        public synchronized CoverageMapStats getStats() {
            if (this.stats == null) {
                this.computeStats();
            }
            return this.stats;
        }

        @Override
        public synchronized double getAverageCoverage() {
            if (this.stats == null) {
                this.computeStats();
            }
            return this.stats.getAvgCoverage();
        }

        public synchronized void computeStats() {
            if (this.isEmpty()) {
                this.stats = new CoverageMapStats(0, 0, 0.0);
                return;
            }
            this.stats = ((Stream)Arrays.stream(this.regions).parallel()).collect(CoverageMapCollectors.computeStats());
        }

        @Override
        public synchronized int getMinCoverage() {
            if (this.stats == null) {
                this.computeStats();
            }
            return this.stats.getMinCoverage();
        }

        @Override
        public synchronized int getMaxCoverage() {
            if (this.stats == null) {
                this.computeStats();
            }
            return this.stats.getMaxCoverage();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CoverageMap) {
                CoverageMap other = (CoverageMap)obj;
                if (this.getNumberOfRegions() != other.getNumberOfRegions()) {
                    return false;
                }
                for (int i = 0; i < this.getNumberOfRegions(); ++i) {
                    if (this.getRegion(i).equals(other.getRegion(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int prime = 37;
            int ret = 17;
            for (CoverageRegion<V> region : this.regions) {
                ret = ret * 37 + region.hashCode();
            }
            return ret;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (CoverageRegion<V> region : this.regions) {
                buf.append(region).append('\n');
            }
            return buf.toString();
        }

        @Override
        public List<CoverageRegion<V>> getRegionsWhichIntersect(Range range) {
            if (range == null) {
                throw new NullPointerException("range can not be null");
            }
            if (this.isEmpty() || range.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.regions[0].asRange().getBegin() > range.getEnd()) {
                return Collections.emptyList();
            }
            if (this.regions[this.regions.length - 1].asRange().getEnd() < range.getBegin()) {
                return Collections.emptyList();
            }
            Object fakeRegion = ((DefaultCoverageRegion.Builder)new DefaultCoverageRegion.Builder(range.getBegin(), Collections.emptyList()).end(range.getEnd())).build();
            int beginIndex = Arrays.binarySearch(this.regions, fakeRegion, CoverageRegionComparators.BY_BEGIN);
            int endIndex = Arrays.binarySearch(this.regions, fakeRegion, CoverageRegionComparators.BY_END);
            int correctedBeginIndex = Math.max(0, beginIndex < 0 ? Math.abs(beginIndex) - 2 : beginIndex);
            int correctedEndIndex = Math.min(this.regions.length - 1, endIndex < 0 ? Math.abs(endIndex) - 1 : endIndex);
            int numberOfRegionsIntersected = correctedEndIndex - correctedBeginIndex + 1;
            ArrayList<CoverageRegion<V>> intersectedRegions = new ArrayList<CoverageRegion<V>>(numberOfRegionsIntersected);
            for (int i = correctedBeginIndex; i <= correctedEndIndex; ++i) {
                if (i >= this.regions.length) continue;
                intersectedRegions.add(this.regions[i]);
            }
            return intersectedRegions;
        }

        @Override
        public CoverageRegion<V> getRegionWhichCovers(long consensusIndex) {
            Range range = Range.of(consensusIndex, consensusIndex);
            List<CoverageRegion<V>> intersectedRegion = this.getRegionsWhichIntersect(range);
            if (intersectedRegion.isEmpty()) {
                return null;
            }
            return intersectedRegion.get(0);
        }

        @Override
        public Iterator<CoverageRegion<V>> iterator() {
            return new ArrayIterator<CoverageRegion<V>>(this.regions, false);
        }

        @Override
        public boolean isEmpty() {
            return this.regions.length == 0;
        }

        @Override
        public Stream<CoverageRegion<V>> regions() {
            return Arrays.stream(this.regions);
        }

        @Override
        public Stream<CoverageRegion<V>> regions(Range range) {
            if (range == null) {
                throw new NullPointerException("range can not be null");
            }
            if (this.isEmpty() || range.isEmpty()) {
                return Collections.emptyList().stream();
            }
            if (this.regions[0].asRange().getBegin() > range.getEnd()) {
                return Collections.emptyList().stream();
            }
            if (this.regions[this.regions.length - 1].asRange().getEnd() < range.getBegin()) {
                return Collections.emptyList().stream();
            }
            Object fakeRegion = ((DefaultCoverageRegion.Builder)new DefaultCoverageRegion.Builder(range.getBegin(), Collections.emptyList()).end(range.getEnd())).build();
            int beginIndex = Arrays.binarySearch(this.regions, fakeRegion, CoverageRegionComparators.BY_BEGIN);
            int endIndex = Arrays.binarySearch(this.regions, fakeRegion, CoverageRegionComparators.BY_END);
            int correctedBeginIndex = Math.max(0, beginIndex < 0 ? Math.abs(beginIndex) - 2 : beginIndex);
            int correctedEndIndex = Math.min(this.regions.length - 1, endIndex < 0 ? Math.abs(endIndex) - 1 : endIndex);
            return Arrays.stream(this.regions, correctedBeginIndex, correctedEndIndex + 1);
        }
    }

    private static class RangeableEndComparator<T extends Rangeable>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 5135449151100427846L;

        private RangeableEndComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            long o2End;
            long o1End = o1.asRange().getEnd();
            if (o1End == (o2End = o2.asRange().getEnd())) {
                return 0;
            }
            if (o1End < o2End) {
                return -1;
            }
            return 1;
        }
    }

    private static class RangeableStartComparator<T extends Rangeable>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -8517894363563047881L;

        private RangeableStartComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            long o2End;
            long o1End = o1.asRange().getBegin();
            if (o1End == (o2End = o2.asRange().getBegin())) {
                return 0;
            }
            if (o1End < o2End) {
                return -1;
            }
            return 1;
        }
    }
}

