/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapBuilder;
import org.jcvi.jillion.assembly.util.CoverageMapStats;
import org.jcvi.jillion.assembly.util.CoverageRegion;
import org.jcvi.jillion.assembly.util.CoverageStatsCombiner;
import org.jcvi.jillion.core.Rangeable;

public final class CoverageMapCollectors {
    private CoverageMapCollectors() {
    }

    public static <T extends Rangeable, R extends CoverageRegion<T>> Collector<R, CoverageStatsCombiner, CoverageMapStats> computeStats() {
        return Collector.of(CoverageStatsCombiner::new, CoverageStatsCombiner::add, CoverageStatsCombiner::merge, CoverageStatsCombiner::build, Collector.Characteristics.UNORDERED, Collector.Characteristics.CONCURRENT);
    }

    public static <T extends Rangeable> Collector<T, List<T>, CoverageMap<T>> toCoverageMap() {
        return Collector.of(ArrayList::new, List::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, list -> new CoverageMapBuilder(list).build(), Collector.Characteristics.UNORDERED);
    }

    public static <T extends Rangeable> Collector<T, List<T>, CoverageMap<T>> toCoverageMap(int maxCoverage) {
        if (maxCoverage < 1) {
            throw new IllegalArgumentException("max coverage must be >=0");
        }
        return Collector.of(ArrayList::new, List::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, list -> new CoverageMapBuilder(list).maxAllowedCoverage(maxCoverage).build(), new Collector.Characteristics[0]);
    }

    public static <T extends Rangeable> Collector<T, List<T>, CoverageMap<T>> toCoverageMap(int preferredMaxCoverage, int requiredMinCoverage) {
        if (preferredMaxCoverage < 1) {
            throw new IllegalArgumentException("max coverage must be >=0");
        }
        if (requiredMinCoverage < 1) {
            throw new IllegalArgumentException("min coverage must be >=0");
        }
        return Collector.of(ArrayList::new, List::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, list -> new CoverageMapBuilder(list).maxAllowedCoverage(preferredMaxCoverage, requiredMinCoverage).build(), new Collector.Characteristics[0]);
    }
}

