/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.Collection;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapFactory;
import org.jcvi.jillion.core.Rangeable;

public final class CoverageMapBuilder<T extends Rangeable> {
    private static final int NOT_SET = -1;
    private final Collection<T> elements;
    private int maxCoverage = -1;
    private int minCoverage = -1;
    private boolean startAtOrigin = false;

    public CoverageMapBuilder(Collection<T> elements) {
        if (elements == null) {
            throw new NullPointerException("elements can not be null");
        }
        this.elements = elements;
    }

    public CoverageMapBuilder<T> maxAllowedCoverage(int maxCoverage) {
        if (maxCoverage < 0) {
            throw new IllegalArgumentException("maxCoverage must be positive");
        }
        this.maxCoverage = maxCoverage;
        return this;
    }

    public CoverageMapBuilder<T> maxAllowedCoverage(int preferredMaxCoverage, int requiredMinCoverage) {
        if (preferredMaxCoverage < 0) {
            throw new IllegalArgumentException("maxCoverage must be positive");
        }
        if (requiredMinCoverage < 0) {
            throw new IllegalArgumentException("requiredMinCoverage must be positive");
        }
        this.maxCoverage = preferredMaxCoverage;
        this.minCoverage = requiredMinCoverage;
        return this;
    }

    public CoverageMap<T> build() {
        if (this.maxCoverage == -1) {
            return CoverageMapFactory.create(this.elements, this.startAtOrigin);
        }
        if (this.minCoverage == -1) {
            return CoverageMapFactory.create(this.elements, this.maxCoverage, this.startAtOrigin);
        }
        return CoverageMapFactory.create(this.elements, this.maxCoverage, this.minCoverage, this.startAtOrigin);
    }

    public CoverageMapBuilder<T> includeOrigin(boolean flag) {
        this.startAtOrigin = flag;
        return this;
    }
}

