/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageMapFactory;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

public final class ContigCoverageMapBuilder<R extends AssembledRead> {
    private static final int NOT_SET = -1;
    private final Contig<R> contig;
    private Predicate<? super R> filter = null;
    private int maxCoverage = -1;
    private int minCoverage = -1;
    private boolean useUngappedCoordinates = false;

    public ContigCoverageMapBuilder(Contig<R> contig) {
        if (contig == null) {
            throw new NullPointerException("contig can not be null");
        }
        this.contig = contig;
    }

    public ContigCoverageMapBuilder<R> maxAllowedCoverage(int maxCoverage) {
        if (maxCoverage < 0) {
            throw new IllegalArgumentException("maxCoverage must be positive");
        }
        this.maxCoverage = maxCoverage;
        return this;
    }

    public ContigCoverageMapBuilder<R> maxAllowedCoverage(int preferredMaxCoverage, int requiredMinCoverage) {
        if (preferredMaxCoverage < 0) {
            throw new IllegalArgumentException("maxCoverage must be positive");
        }
        if (requiredMinCoverage < 0) {
            throw new IllegalArgumentException("requiredMinCoverage must be positive");
        }
        this.maxCoverage = preferredMaxCoverage;
        this.minCoverage = requiredMinCoverage;
        return this;
    }

    public ContigCoverageMapBuilder<R> filter(Predicate<? super R> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    public ContigCoverageMapBuilder<R> useUngappedCoordinates() {
        this.useUngappedCoordinates = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageMap<R> build() {
        StreamingIterator<R> iter = null;
        ArrayList<AssembledRead> readsToInclude = new ArrayList<AssembledRead>(MapUtil.computeMinHashMapSizeWithoutRehashing(this.contig.getNumberOfReads()));
        try {
            iter = this.contig.getReadIterator();
            while (iter.hasNext()) {
                AssembledRead read = (AssembledRead)iter.next();
                if (this.filter != null && !this.filter.test(read)) continue;
                readsToInclude.add(read);
            }
            CoverageMap gappedCoverageMap = this.maxCoverage == -1 ? CoverageMapFactory.create(readsToInclude) : (this.minCoverage == -1 ? CoverageMapFactory.create(readsToInclude, this.maxCoverage) : CoverageMapFactory.create(readsToInclude, this.maxCoverage, this.minCoverage));
            if (this.useUngappedCoordinates) {
                CoverageMap coverageMap = CoverageMapFactory.createUngappedCoverageMap(this.contig.getConsensusSequence(), gappedCoverageMap);
                return coverageMap;
            }
            CoverageMap coverageMap = gappedCoverageMap;
            return coverageMap;
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }
}

