/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.jcvi.jillion.assembly.util.CoverageMap;
import org.jcvi.jillion.assembly.util.CoverageRegionBuilder;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.Rangeable;
import org.jcvi.jillion.core.util.Builder;

abstract class AbstractCoverageMapBuilder<P extends Rangeable>
implements Builder<CoverageMap<P>> {
    private P enteringObject;
    private P leavingObject;
    private Range enteringObjectRange;
    private Range leavingObjectRange;
    private final Queue<P> coveringObjects;
    private Iterator<P> enteringIterator;
    private Iterator<P> leavingIterator;
    private List<CoverageRegionBuilder<P>> coverageRegionBuilders;
    private final Integer maxAllowedCoverage;
    private final Integer minRequiredCoverage;
    private final List<P> sortedOverMaxCoverageObjects = new LinkedList<P>();

    protected abstract Iterator<P> createEnteringIterator();

    protected abstract Iterator<P> createLeavingIterator();

    protected abstract CoverageMap<P> build(List<CoverageRegionBuilder<P>> var1);

    public AbstractCoverageMapBuilder() {
        this.coveringObjects = new ArrayDeque<P>();
        this.maxAllowedCoverage = null;
        this.minRequiredCoverage = null;
    }

    public AbstractCoverageMapBuilder(int maxAllowedCoverage) {
        this.coveringObjects = new ArrayBlockingQueue<P>(maxAllowedCoverage);
        this.maxAllowedCoverage = maxAllowedCoverage;
        this.minRequiredCoverage = null;
    }

    public AbstractCoverageMapBuilder(int maxAllowedCoverage, int minRequiredCoverage) {
        this.coveringObjects = new ArrayBlockingQueue<P>(maxAllowedCoverage);
        this.maxAllowedCoverage = maxAllowedCoverage;
        this.minRequiredCoverage = minRequiredCoverage;
    }

    @Override
    public CoverageMap<P> build() {
        this.initialize();
        this.createListOfRegionBuilders();
        return this.build(this.coverageRegionBuilders);
    }

    private void initialize() {
        this.enteringIterator = this.createEnteringIterator();
        this.leavingIterator = this.createLeavingIterator();
        this.enteringObject = this.getNextObject(this.enteringIterator);
        this.enteringObjectRange = this.enteringObject == null ? null : this.enteringObject.asRange();
        this.leavingObject = this.getNextObject(this.leavingIterator);
        this.leavingObjectRange = this.leavingObject == null ? null : this.leavingObject.asRange();
        this.coverageRegionBuilders = new ArrayList<CoverageRegionBuilder<P>>();
    }

    private void createListOfRegionBuilders() {
        this.createAllRegionBuilders();
        if (this.anyRegionBuildersCreated()) {
            this.removeLastRegionBuilder();
            this.removeAnyBuildersWithEmptyRanges();
            this.addSkippedReadsIfPossible();
            this.combineConsecutiveRegionsWithSameCoveringObjects();
        }
    }

    private void addSkippedReadsIfPossible() {
        if (this.minRequiredCoverage == null || this.sortedOverMaxCoverageObjects.isEmpty()) {
            return;
        }
        Collections.sort(this.sortedOverMaxCoverageObjects, MinCoverageSelectorComparator.INSTANCE);
        int minCoverageLevel = this.minRequiredCoverage;
        if (this.sortedOverMaxCoverageObjects.isEmpty()) {
            return;
        }
        for (Rangeable e : this.sortedOverMaxCoverageObjects) {
            Range range = e.asRange();
            List<CoverageRegionBuilder<P>> intersectingRegions = this.getIntersectionRegionBuilders(range.getBegin(), range.getEnd());
            if (!this.readProvidesMinRequiredCoverage(minCoverageLevel, intersectingRegions)) continue;
            this.addReadToCoverageRegionBuilders(e, range, intersectingRegions);
        }
    }

    private void addReadToCoverageRegionBuilders(P e, Range range, List<CoverageRegionBuilder<P>> intersectingRegions) {
        for (CoverageRegionBuilder<P> builder : intersectingRegions) {
            int i;
            long builderStart = builder.start();
            long builderEnd = builder.end();
            if (range.getBegin() <= builderStart && range.getEnd() >= builderEnd) {
                builder.forceAdd(e);
                continue;
            }
            Collection<P> oldElements = builder.getElements();
            if (range.getBegin() > builderStart) {
                CoverageRegionBuilder<P> rightBuilder = this.createNewCoverageRegionBuilder(oldElements, builderStart, null).end(range.getBegin() - 1L);
                CoverageRegionBuilder<P> leftBuilder = this.createNewCoverageRegionBuilder(oldElements, range.getBegin(), null).add(e).end(builderEnd);
                i = this.getBuilderOffsetFor(builderStart);
                this.coverageRegionBuilders.remove(i);
                this.coverageRegionBuilders.add(i, leftBuilder);
                this.coverageRegionBuilders.add(i, rightBuilder);
                continue;
            }
            CoverageRegionBuilder<P> leftBuilder = this.createNewCoverageRegionBuilder(oldElements, builderStart, null);
            leftBuilder.offer(e);
            leftBuilder.end(range.getEnd());
            CoverageRegionBuilder<P> rightBuilder = this.createNewCoverageRegionBuilder(oldElements, range.getEnd() + 1L, null);
            rightBuilder.end(builderEnd);
            i = this.getBuilderOffsetFor(builderStart);
            this.coverageRegionBuilders.remove(i);
            this.coverageRegionBuilders.add(i, leftBuilder);
            this.coverageRegionBuilders.add(i, rightBuilder);
        }
    }

    private boolean readProvidesMinRequiredCoverage(int minCoverageLevel, List<CoverageRegionBuilder<P>> intersectingRegions) {
        boolean shouldAdd = false;
        for (CoverageRegionBuilder<P> builder : intersectingRegions) {
            if (builder.getCurrentCoverageDepth() >= minCoverageLevel) continue;
            shouldAdd = true;
            break;
        }
        return shouldAdd;
    }

    private void combineConsecutiveRegionsWithSameCoveringObjects() {
        CoverageRegionBuilder<P> previousBuilder = null;
        for (int i = this.coverageRegionBuilders.size() - 1; i >= 0; --i) {
            CoverageRegionBuilder<P> builder = this.coverageRegionBuilders.get(i);
            if (builder.hasSameElementsAs(previousBuilder)) {
                builder.end(previousBuilder.end());
                this.coverageRegionBuilders.remove(i + 1);
            }
            previousBuilder = builder;
        }
    }

    private void removeAnyBuildersWithEmptyRanges() {
        for (int i = this.coverageRegionBuilders.size() - 1; i >= 0; --i) {
            if (!this.coverageRegionBuilders.get(i).rangeIsEmpty()) continue;
            this.coverageRegionBuilders.remove(i);
        }
    }

    private boolean anyRegionBuildersCreated() {
        return !this.coverageRegionBuilders.isEmpty();
    }

    private void removeLastRegionBuilder() {
        this.coverageRegionBuilders.remove(this.coverageRegionBuilders.size() - 1);
    }

    private void createAllRegionBuilders() {
        this.computeRegionsForAllEnteringObjects();
        this.computeRemainingRegions();
    }

    private void computeRegionsForAllEnteringObjects() {
        while (this.stillHaveEnteringObjects()) {
            if (this.isEntering()) {
                this.handleEnteringObject();
                continue;
            }
            if (this.isAbutment()) {
                this.removeAndAdvanceLeavingObject();
                continue;
            }
            this.handleLeavingObject();
        }
    }

    private int getBuilderOffsetFor(long startCoord) {
        for (int i = 0; i < this.coverageRegionBuilders.size(); ++i) {
            if (startCoord != this.coverageRegionBuilders.get(i).start()) continue;
            return i;
        }
        throw new IllegalStateException("no coverage region builder with start coord " + startCoord);
    }

    private List<CoverageRegionBuilder<P>> getIntersectionRegionBuilders(long start, long end) {
        CoverageRegionBuilder<P> builder;
        long regionStart;
        ArrayList<CoverageRegionBuilder<P>> intersectingRegions = new ArrayList<CoverageRegionBuilder<P>>();
        for (int i = 0; i < this.coverageRegionBuilders.size() && (regionStart = (builder = this.coverageRegionBuilders.get(i)).start()) <= end; ++i) {
            if (regionStart < start) continue;
            intersectingRegions.add(builder);
        }
        return intersectingRegions;
    }

    private boolean stillHaveEnteringObjects() {
        return this.enteringObject != null;
    }

    private void computeRemainingRegions() {
        while (this.stillHaveLeavingObjects()) {
            this.createNewRegionWithoutCurrentLeavingObject();
            this.skipAllLeavingObjectsWithSameEndCoordinate();
        }
    }

    private boolean stillHaveLeavingObjects() {
        return this.leavingObject != null;
    }

    private void skipAllLeavingObjectsWithSameEndCoordinate() {
        long endCoord = this.leavingObject.asRange().getEnd();
        this.leavingObject = this.getNextObject(this.leavingIterator);
        Range range = this.leavingObjectRange = this.leavingObject == null ? null : this.leavingObject.asRange();
        while (this.stillHaveLeavingObjects() && this.currentLeavingObjectHasEndCoordinate(endCoord)) {
            this.removeLeavingObjectFromPreviousRegionBuilder();
            this.removeAndAdvanceLeavingObject();
        }
    }

    private void removeLeavingObjectFromPreviousRegionBuilder() {
        this.getPreviousRegion().remove(this.leavingObject);
    }

    private boolean currentLeavingObjectHasEndCoordinate(long endCoord) {
        return this.leavingObject.asRange().getEnd() == endCoord;
    }

    private void handleEnteringObject() {
        long startCoord = this.enteringObjectRange.getBegin();
        this.createNewRegionWithEnteringAmplicon();
        this.enteringObject = this.getNextObject(this.enteringIterator);
        this.enteringObjectRange = this.enteringObject == null ? null : this.enteringObject.asRange();
        this.handleAmpliconsWithSameStartCoord(startCoord);
    }

    private void handleLeavingObject() {
        this.createNewRegionWithoutCurrentLeavingObject();
        this.skipAllLeavingObjectsWithSameEndCoordinate();
    }

    private void removeAndAdvanceLeavingObject() {
        this.coveringObjects.remove(this.leavingObject);
        this.leavingObject = this.getNextObject(this.leavingIterator);
        this.leavingObjectRange = this.leavingObject == null ? null : this.leavingObject.asRange();
    }

    private boolean isAbutment() {
        return this.leavingObjectRange.getEnd() == this.enteringObjectRange.getBegin() - 1L;
    }

    private void handleAmpliconsWithSameStartCoord(long regionStart) {
        while (this.stillHaveEnteringObjects() && this.enteringObjectRange.getBegin() == regionStart) {
            this.addEnteringObjectToPreviousRegionBuilder();
            this.addAndAdvanceEnteringObject();
        }
    }

    private void addEnteringObjectToPreviousRegionBuilder() {
        if (!this.getPreviousRegion().offer(this.enteringObject) && this.minRequiredCoverage != null) {
            this.sortedOverMaxCoverageObjects.add(this.enteringObject);
        }
    }

    private void addAndAdvanceEnteringObject() {
        this.coveringObjects.offer(this.enteringObject);
        this.enteringObject = this.getNextObject(this.enteringIterator);
        this.enteringObjectRange = this.enteringObject == null ? null : this.enteringObject.asRange();
    }

    private boolean isEntering() {
        return this.enteringObjectRange.getBegin() <= this.leavingObjectRange.getEnd();
    }

    private void createNewRegionWithoutCurrentLeavingObject() {
        this.coveringObjects.remove(this.leavingObject);
        long endCoordinate = this.leavingObjectRange.getEnd();
        this.setEndCoordinateOfPreviousRegion(endCoordinate);
        this.coverageRegionBuilders.add(this.createNewCoverageRegionBuilder(this.coveringObjects, this.leavingObjectRange.getEnd() + 1L, this.maxAllowedCoverage));
    }

    private void setEndCoordinateOfPreviousRegion(long endCoordinate) {
        this.getPreviousRegion().end(endCoordinate);
    }

    private void createNewRegionWithEnteringAmplicon() {
        boolean added;
        if (!this.coverageRegionBuilders.isEmpty()) {
            long endCoordinate = this.enteringObjectRange.getBegin() - 1L;
            this.setEndCoordinateOfPreviousRegion(endCoordinate);
        }
        if (!(added = this.coveringObjects.offer(this.enteringObject)) && this.minRequiredCoverage != null) {
            this.sortedOverMaxCoverageObjects.add(this.enteringObject);
        }
        this.coverageRegionBuilders.add(this.createNewCoverageRegionBuilder(this.coveringObjects, this.enteringObjectRange.getBegin(), this.maxAllowedCoverage));
    }

    protected abstract CoverageRegionBuilder<P> createNewCoverageRegionBuilder(Collection<P> var1, long var2, Integer var4);

    private CoverageRegionBuilder<P> getPreviousRegion() {
        return this.coverageRegionBuilders.get(this.coverageRegionBuilders.size() - 1);
    }

    private P getNextObject(Iterator<P> iterator) {
        return (P)(iterator.hasNext() ? (Rangeable)iterator.next() : null);
    }

    private static enum MinCoverageSelectorComparator implements Comparator<Rangeable>
    {
        INSTANCE;


        @Override
        public int compare(Rangeable o1, Rangeable o2) {
            return Range.Comparators.LONGEST_TO_SHORTEST.compare(o1.asRange(), o2.asRange());
        }
    }
}

