/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

final class TasmUtil {
    private static ThreadLocal<DateFormat> EDIT_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("MM/dd/yy hh:mm:ss aa", Locale.US);
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };

    private TasmUtil() {
    }

    public static Date parseEditDate(String editDate) throws ParseException {
        if (editDate == null) {
            throw new NullPointerException("edit date can not be null");
        }
        return EDIT_DATE_FORMAT.get().parse(editDate);
    }

    public static String formatEditDate(Date editDate) {
        if (editDate == null) {
            throw new NullPointerException("edit date can not be null");
        }
        return EDIT_DATE_FORMAT.get().format(editDate);
    }
}

