/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.util.HashMap;
import java.util.Map;

enum TasmReadAttribute {
    NAME("seq_name"),
    CONTIG_LEFT("asm_lend"),
    CONTIG_RIGHT("asm_rend"),
    SEQUENCE_LEFT("seq_lend"),
    SEQUENCE_RIGHT("seq_rend"),
    BEST("best"),
    COMMENT("comment"),
    DB("db"),
    CONTIG_START_OFFSET("offset"),
    GAPPED_SEQUENCE("lsequence");

    private final String assemblyTableColumn;
    private static final Map<String, TasmReadAttribute> MAP;

    private TasmReadAttribute(String assemblyTableColumn) {
        this.assemblyTableColumn = assemblyTableColumn;
    }

    public String getAssemblyTableColumn() {
        return this.assemblyTableColumn;
    }

    public static TasmReadAttribute getAttributeFor(String attribute) {
        if (MAP.containsKey(attribute)) {
            return MAP.get(attribute);
        }
        throw new IllegalArgumentException("unknown attribute " + attribute);
    }

    static {
        MAP = new HashMap<String, TasmReadAttribute>();
        for (TasmReadAttribute attribute : TasmReadAttribute.values()) {
            MAP.put(attribute.getAssemblyTableColumn(), attribute);
        }
    }
}

