/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.jcvi.jillion.assembly.tigr.tasm.TasmAssembledRead;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigAttribute;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.TasmReadAttribute;
import org.jcvi.jillion.assembly.tigr.tasm.TasmUtil;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.datastore.DataStoreException;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.core.residue.nt.ReferenceMappedNucleotideSequence;
import org.jcvi.jillion.core.util.iter.StreamingIterator;

final class TasmFileWriterUtil {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] BLANK_LINE = "\n".getBytes(UTF_8);
    private static final byte[] CONTIG_SEPARATOR = "|\n".getBytes(UTF_8);
    private static final String EOL = "\n";

    private TasmFileWriterUtil() {
    }

    public static void writeContigSeparator(OutputStream out) throws IOException {
        out.write(CONTIG_SEPARATOR);
    }

    public static void write(TasmContigDataStore datastore, OutputStream out) throws IOException {
        if (datastore == null) {
            throw new NullPointerException("data store can not be null");
        }
        StreamingIterator iter = null;
        try {
            iter = datastore.iterator();
            while (iter.hasNext()) {
                TasmContig contig = (TasmContig)iter.next();
                TasmFileWriterUtil.write(contig, out);
                if (!iter.hasNext()) continue;
                out.write(CONTIG_SEPARATOR);
            }
        }
        catch (DataStoreException e) {
            throw new IOException("error writing tasm file", e);
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    public static void writeAnnotationRecord(TasmContig contig, OutputStream out) throws IOException {
        Map<TasmContigAttribute, String> currentContigAttributes = TasmFileWriterUtil.createContigAttributes(contig);
        for (TasmContigAttribute contigAttribute : TasmContigAttribute.values()) {
            if (!currentContigAttributes.containsKey((Object)contigAttribute)) continue;
            String assemblyTableColumn = contigAttribute.getAssemblyTableColumn();
            StringBuilder row = new StringBuilder(assemblyTableColumn);
            int padding = 4 - assemblyTableColumn.length() % 4;
            if (padding > 0) {
                row.append('\t');
            }
            row.append(String.format("%s%s", currentContigAttributes.get((Object)contigAttribute), EOL));
            out.write(row.toString().getBytes(UTF_8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(TasmContig contig, OutputStream out) throws IOException {
        TasmFileWriterUtil.writeAnnotationRecord(contig, out);
        if (contig.getNumberOfReads() > 0L) {
            out.write(BLANK_LINE);
            StreamingIterator placedReadIterator = null;
            try {
                placedReadIterator = contig.getReadIterator();
                while (placedReadIterator.hasNext()) {
                    TasmAssembledRead read = (TasmAssembledRead)placedReadIterator.next();
                    Map<TasmReadAttribute, String> currentAttributes = TasmFileWriterUtil.createReadAttributes(read);
                    for (TasmReadAttribute readAttribute : TasmReadAttribute.values()) {
                        String assemblyTableColumn = readAttribute.getAssemblyTableColumn();
                        int padding = 4 - assemblyTableColumn.length() % 4;
                        StringBuilder row = new StringBuilder(assemblyTableColumn);
                        if (padding > 0) {
                            row.append('\t');
                        }
                        if (currentAttributes.containsKey((Object)readAttribute)) {
                            row.append(String.format("%s%s", currentAttributes.get((Object)readAttribute), EOL));
                        } else {
                            row.append(EOL);
                        }
                        out.write(row.toString().getBytes(UTF_8));
                    }
                    if (!placedReadIterator.hasNext()) continue;
                    out.write(BLANK_LINE);
                }
            }
            finally {
                IOUtil.closeAndIgnoreErrors(placedReadIterator);
            }
        }
    }

    private static Map<TasmReadAttribute, String> createReadAttributes(TasmAssembledRead read) {
        EnumMap<TasmReadAttribute, String> map = new EnumMap<TasmReadAttribute, String>(TasmReadAttribute.class);
        map.put(TasmReadAttribute.NAME, read.getId());
        map.put(TasmReadAttribute.CONTIG_START_OFFSET, Long.toString(read.getGappedStartOffset()));
        ReferenceMappedNucleotideSequence gappedSequence = read.getNucleotideSequence();
        map.put(TasmReadAttribute.GAPPED_SEQUENCE, gappedSequence.toString());
        Range validRange = read.getReadInfo().getValidRange();
        if (read.getDirection() == Direction.FORWARD) {
            map.put(TasmReadAttribute.SEQUENCE_LEFT, Long.toString(validRange.getBegin(Range.CoordinateSystem.RESIDUE_BASED)));
            map.put(TasmReadAttribute.SEQUENCE_RIGHT, Long.toString(validRange.getEnd(Range.CoordinateSystem.RESIDUE_BASED)));
        } else {
            map.put(TasmReadAttribute.SEQUENCE_RIGHT, Long.toString(validRange.getBegin(Range.CoordinateSystem.RESIDUE_BASED)));
            map.put(TasmReadAttribute.SEQUENCE_LEFT, Long.toString(validRange.getEnd(Range.CoordinateSystem.RESIDUE_BASED)));
        }
        NucleotideSequence consensus = gappedSequence.getReferenceSequence();
        map.put(TasmReadAttribute.CONTIG_LEFT, Long.toString(1 + consensus.getUngappedOffsetFor((int)read.getGappedStartOffset())));
        map.put(TasmReadAttribute.CONTIG_RIGHT, Long.toString(1 + consensus.getUngappedOffsetFor((int)read.getGappedEndOffset())));
        return map;
    }

    private static long getNumberOfReads(TasmContig contig) {
        return contig.getNumberOfReads();
    }

    private static double getAvgCoverage(TasmContig contig) {
        return contig.getAvgCoverage();
    }

    private static String getEditPerson(TasmContig contig) {
        return contig.getEditPerson();
    }

    private static Date getEditDate(TasmContig contig) {
        return contig.getEditDate();
    }

    private static Map<TasmContigAttribute, String> createContigAttributes(TasmContig contig) {
        EnumMap<TasmContigAttribute, String> map = new EnumMap<TasmContigAttribute, String>(TasmContigAttribute.class);
        NucleotideSequenceBuilder nucleotideSequenceBuilder = new NucleotideSequenceBuilder(contig.getConsensusSequence());
        double numNs = nucleotideSequenceBuilder.getNumNs();
        map.put(TasmContigAttribute.PERCENT_N, String.format("%.2f", numNs / (double)nucleotideSequenceBuilder.getLength()));
        map.put(TasmContigAttribute.UNGAPPED_CONSENSUS, nucleotideSequenceBuilder.ungap().toString());
        map.put(TasmContigAttribute.GAPPED_CONSENSUS, contig.getConsensusSequence().toString());
        map.put(TasmContigAttribute.NUMBER_OF_READS, Long.toString(TasmFileWriterUtil.getNumberOfReads(contig)));
        map.put(TasmContigAttribute.AVG_COVERAGE, String.format("%.2f", TasmFileWriterUtil.getAvgCoverage(contig)));
        map.put(TasmContigAttribute.EDIT_PERSON, TasmFileWriterUtil.getEditPerson(contig));
        map.put(TasmContigAttribute.EDIT_DATE, TasmUtil.formatEditDate(TasmFileWriterUtil.getEditDate(contig)));
        map.put(TasmContigAttribute.IS_CIRCULAR, contig.isCircular() ? "1" : "0");
        TasmFileWriterUtil.putOptionalValue(map, TasmContigAttribute.BAC_ID, contig.getSampleId());
        TasmFileWriterUtil.putOptionalValue(map, TasmContigAttribute.ASMBL_ID, contig.getTigrProjectAssemblyId());
        TasmFileWriterUtil.putOptionalValue(map, TasmContigAttribute.CA_CONTIG_ID, contig.getCeleraAssemblerId());
        TasmFileWriterUtil.putOptionalValue(map, TasmContigAttribute.COMMENT, contig.getComment());
        TasmFileWriterUtil.putOptionalValue(map, TasmContigAttribute.COM_NAME, contig.getCommonName());
        TasmFileWriterUtil.putOptionalValue(map, TasmContigAttribute.METHOD, contig.getAssemblyMethod());
        return map;
    }

    private static void putOptionalValue(Map<TasmContigAttribute, String> map, TasmContigAttribute attribute, Object value) {
        if (value != null) {
            map.put(attribute, value.toString());
        }
    }
}

