/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.assembly.tigr.tasm.TasmFileWriterUtil;
import org.jcvi.jillion.assembly.tigr.tasm.TasmWriter;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.util.Builder;

public final class TasmFileWriterBuilder
implements Builder<TasmWriter> {
    private final File outputFile;
    private final OutputStream out;
    private boolean annotationContigs = false;

    public TasmFileWriterBuilder(File outputTasmFile) {
        if (outputTasmFile == null) {
            throw new NullPointerException("output file can not be null");
        }
        this.outputFile = outputTasmFile;
        this.out = null;
    }

    public TasmFileWriterBuilder writeAnnotationContigs() {
        this.annotationContigs = true;
        return this;
    }

    public TasmFileWriterBuilder(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("outputStream can not be null");
        }
        this.outputFile = null;
        this.out = out;
    }

    @Override
    public TasmWriter build() {
        if (this.outputFile == null) {
            return new TasmFileWriter(this.out, this.annotationContigs);
        }
        try {
            return new TasmFileWriter(this.outputFile, this.annotationContigs);
        }
        catch (IOException e) {
            throw new IllegalStateException("error creating tasm writer", e);
        }
    }

    private static final class TasmFileWriter
    implements TasmWriter {
        private final OutputStream out;
        private final boolean writeAnnotationContigs;
        private int numberOfContigsWritten = 0;

        public TasmFileWriter(File outputFile, boolean writeAnnotationContigs) throws IOException {
            IOUtil.mkdirs(outputFile);
            this.out = new BufferedOutputStream(new FileOutputStream(outputFile));
            this.writeAnnotationContigs = writeAnnotationContigs;
        }

        public TasmFileWriter(OutputStream out, boolean writeAnnotationContigs) {
            this.out = out;
            this.writeAnnotationContigs = writeAnnotationContigs;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void write(TasmContig contig) throws IOException {
            if (this.numberOfContigsWritten > 0) {
                TasmFileWriterUtil.writeContigSeparator(this.out);
            }
            if (this.writeAnnotationContigs) {
                TasmFileWriterUtil.writeAnnotationRecord(contig, this.out);
            } else {
                TasmFileWriterUtil.write(contig, this.out);
            }
            ++this.numberOfContigsWritten;
        }
    }
}

