/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigAttribute;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigReadVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmParser;
import org.jcvi.jillion.assembly.tigr.tasm.TasmReadAttribute;
import org.jcvi.jillion.assembly.tigr.tasm.TasmUtil;
import org.jcvi.jillion.assembly.tigr.tasm.TasmVisitor;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceBuilder;
import org.jcvi.jillion.internal.core.io.OpenAwareInputStream;
import org.jcvi.jillion.internal.core.io.RandomAccessFileInputStream;
import org.jcvi.jillion.internal.core.io.TextLineParser;

public abstract class TasmFileParser
implements TasmParser {
    private static final String END_OF_CONTIG = "|";
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("(\\S+)\\s+(\\S+.*$)");

    public static TasmParser create(File tasmFile) throws IOException {
        return new FileBasedTasmFileParser(tasmFile);
    }

    public static TasmParser create(InputStream in) {
        return new InputStreamBasedTasmFileParser(in);
    }

    private TasmFileParser() {
    }

    final void parseTasm(TextLineParser parser, TasmVisitor visitor) throws IOException {
        ParserState parserState = new ParserState(visitor);
        while (parser.hasNextLine() && parserState.keepParsing()) {
            String line = parser.nextLine();
            Matcher matcher = KEY_VALUE_PATTERN.matcher(line);
            if (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2).trim();
                parserState.handleCurrentAttribute(key, value);
                continue;
            }
            parserState.fireEndOfContigHeader();
            boolean endOfRecord = TasmFileParser.isEndOfRecord(line);
            boolean endOfContig = TasmFileParser.isEndOfContig(line);
            if (!endOfRecord && !endOfContig) continue;
            parserState.fireEndOfRead();
            if (endOfContig) {
                parserState.handleEndOfContig();
                parserState.beginNewContig(parser.getPosition());
                continue;
            }
            parserState.beginNewRead();
        }
        parserState.fireEndOfContigHeader();
        parserState.fireEndOfRead();
        parserState.handleEndOfContig();
        visitor.visitEnd();
    }

    private static boolean isEndOfContig(String line) {
        return line.trim().equals(END_OF_CONTIG);
    }

    private static final boolean isEndOfRecord(String line) {
        return line.trim().isEmpty();
    }

    abstract AbstractCallback createCallback(long var1);

    private static final class InputStreamBasedTasmFileParser
    extends TasmFileParser {
        private final OpenAwareInputStream in;

        public InputStreamBasedTasmFileParser(InputStream in) {
            this.in = new OpenAwareInputStream(new BufferedInputStream(in));
        }

        @Override
        protected AbstractCallback createCallback(long offset) {
            return new NoMementoCallback();
        }

        @Override
        public void parse(TasmVisitor visitor) throws IOException {
            if (!this.canParse()) {
                throw new IOException("inputstream is closed");
            }
            TextLineParser parser = new TextLineParser(this.in);
            try {
                this.parseTasm(parser, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser, this.in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors(parser, this.in);
        }

        @Override
        public boolean canParse() {
            return this.in.isOpen();
        }

        @Override
        public void parse(TasmVisitor visitor, TasmVisitor.TasmVisitorCallback.TasmVisitorMemento memento) throws IOException {
            throw new UnsupportedOperationException("mementos not supported");
        }
    }

    private static final class FileBasedTasmFileParser
    extends TasmFileParser {
        private final File tasmFile;

        public FileBasedTasmFileParser(File tasmFile) throws FileNotFoundException {
            if (!tasmFile.exists()) {
                throw new FileNotFoundException("tasm file does not exist : " + tasmFile.getAbsolutePath());
            }
            if (!tasmFile.canRead()) {
                throw new FileNotFoundException("tasm file is not readable : " + tasmFile.getAbsolutePath());
            }
            this.tasmFile = tasmFile;
        }

        @Override
        protected AbstractCallback createCallback(long offset) {
            return new OffsetMementoCallback(offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(TasmVisitor visitor) throws IOException {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.tasmFile));
            TextLineParser parser = new TextLineParser(in);
            try {
                this.parseTasm(parser, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(parser, in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors(parser, in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(TasmVisitor visitor, TasmVisitor.TasmVisitorCallback.TasmVisitorMemento memento) throws IOException {
            if (!(memento instanceof OffsetMemento)) {
                throw new IllegalArgumentException("unknown memento type");
            }
            long startOffset = ((OffsetMemento)memento).getOffset();
            long fileLength = this.tasmFile.length();
            if (fileLength <= startOffset) {
                throw new IllegalArgumentException("memento seeks beyond file");
            }
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new RandomAccessFileInputStream(this.tasmFile, startOffset));
                TextLineParser parser = new TextLineParser(in, startOffset);
                this.parseTasm(parser, visitor);
            }
            catch (Throwable throwable) {
                IOUtil.closeAndIgnoreErrors(in);
                throw throwable;
            }
            IOUtil.closeAndIgnoreErrors((Closeable)in);
        }

        @Override
        public boolean canParse() {
            return true;
        }
    }

    private static class ReadState {
        private NucleotideSequence sequence;
        private String id;
        private long gappedStartOffset;
        private int seqLeft;
        private int seqRight;

        private ReadState() {
        }

        public void handleAttribute(String key, String value) throws IOException {
            TasmReadAttribute attribute = TasmReadAttribute.getAttributeFor(key);
            switch (attribute) {
                case GAPPED_SEQUENCE: {
                    this.sequence = new NucleotideSequenceBuilder(value).build();
                    break;
                }
                case NAME: {
                    this.id = value.trim();
                    break;
                }
                case CONTIG_START_OFFSET: {
                    this.gappedStartOffset = Long.parseLong(value);
                    break;
                }
                case SEQUENCE_LEFT: {
                    this.seqLeft = Integer.parseInt(value);
                    break;
                }
                case SEQUENCE_RIGHT: {
                    this.seqRight = Integer.parseInt(value);
                    break;
                }
            }
        }
    }

    private static class ContigState {
        private String contigId;
        private float avgCoverage = 0.0f;
        private NucleotideSequence consensus;
        private Long caContigId = null;
        private String comment;
        private String comName;
        private String editPerson;
        private String assemblyMethod;
        private long editDate;
        private boolean isCircular = false;
        private int numberOfReads = 0;
        private Integer bacId;

        private ContigState() {
        }

        public void handleAttribute(String key, String value) throws IOException {
            TasmContigAttribute attribute = TasmContigAttribute.getAttributeFor(key);
            switch (attribute) {
                case ASMBL_ID: {
                    this.contigId = value;
                    break;
                }
                case AVG_COVERAGE: {
                    this.avgCoverage = Float.parseFloat(value);
                    break;
                }
                case CA_CONTIG_ID: {
                    this.caContigId = Long.parseLong(value);
                    break;
                }
                case BAC_ID: {
                    this.bacId = Integer.parseInt(value);
                    break;
                }
                case COM_NAME: {
                    this.comName = value;
                    break;
                }
                case COMMENT: {
                    this.comment = value;
                    break;
                }
                case EDIT_DATE: {
                    try {
                        this.editDate = TasmUtil.parseEditDate(value).getTime();
                        break;
                    }
                    catch (ParseException e) {
                        throw new IOException("error parsing edit date " + value, e);
                    }
                }
                case EDIT_PERSON: {
                    this.editPerson = value;
                    break;
                }
                case GAPPED_CONSENSUS: {
                    this.consensus = new NucleotideSequenceBuilder(value).build();
                    break;
                }
                case IS_CIRCULAR: {
                    this.isCircular = "1".equals(value);
                    break;
                }
                case METHOD: {
                    this.assemblyMethod = value;
                    break;
                }
                case NUMBER_OF_READS: {
                    this.numberOfReads = Integer.parseInt(value);
                    break;
                }
            }
        }

        public TasmContigVisitor handleContigHeader(AbstractCallback callback, TasmVisitor visitor) {
            TasmContigVisitor contigVisitor = visitor.visitContig(callback, this.contigId);
            if (callback.keepParsing() && contigVisitor != null) {
                contigVisitor.visitConsensus(this.consensus);
                this.visitCaId(callback, contigVisitor);
                this.visitComments(callback, contigVisitor);
                this.visitCoverage(callback, contigVisitor);
                this.visitEnd(callback, contigVisitor);
            }
            return contigVisitor;
        }

        private void visitEnd(AbstractCallback callback, TasmContigVisitor contigVisitor) {
            if (callback.keepParsing()) {
                contigVisitor.visitLastEdited(this.editPerson, new Date(this.editDate));
            } else {
                contigVisitor.halted();
            }
        }

        private void visitCoverage(AbstractCallback callback, TasmContigVisitor contigVisitor) {
            if (callback.keepParsing()) {
                contigVisitor.visitCoverageData(this.numberOfReads, this.avgCoverage);
            } else {
                contigVisitor.halted();
            }
        }

        private void visitComments(AbstractCallback callback, TasmContigVisitor contigVisitor) {
            if (callback.keepParsing()) {
                contigVisitor.visitComments(this.bacId, this.comment, this.comName, this.assemblyMethod, this.isCircular);
            } else {
                contigVisitor.halted();
            }
        }

        private void visitCaId(AbstractCallback callback, TasmContigVisitor contigVisitor) {
            if (callback.keepParsing() && this.caContigId != null) {
                contigVisitor.visitCeleraId(this.caContigId);
            } else {
                contigVisitor.halted();
            }
        }
    }

    private class ParserState {
        ContigState currentContigState = new ContigState();
        ReadState currentReadState = null;
        AbstractCallback callback = null;
        TasmContigVisitor contigVisitor = null;
        private final TasmVisitor visitor;
        private long beginContigHeaderOffset;

        public ParserState(TasmVisitor visitor) {
            this.visitor = visitor;
        }

        public boolean keepParsing() {
            return this.callback == null || this.callback.keepParsing();
        }

        public void handleCurrentAttribute(String key, String value) throws IOException {
            if (this.currentContigState == null) {
                this.currentReadState.handleAttribute(key, value);
            } else {
                this.currentContigState.handleAttribute(key, value);
            }
        }

        public void beginNewContig(long currentOffset) {
            if (this.keepParsing()) {
                this.currentContigState = new ContigState();
                this.beginContigHeaderOffset = currentOffset;
            }
        }

        public void beginNewRead() {
            this.currentReadState = new ReadState();
        }

        protected void fireEndOfRead() {
            Range validRange;
            Direction dir;
            if (!this.keepParsing() || this.currentReadState == null || this.contigVisitor == null) {
                return;
            }
            if (this.currentReadState.seqRight < this.currentReadState.seqLeft) {
                dir = Direction.REVERSE;
                validRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, this.currentReadState.seqRight, this.currentReadState.seqLeft);
            } else {
                dir = Direction.FORWARD;
                validRange = Range.of(Range.CoordinateSystem.RESIDUE_BASED, this.currentReadState.seqLeft, this.currentReadState.seqRight);
            }
            TasmContigReadVisitor readVisitor = this.contigVisitor.visitRead(this.currentReadState.id, this.currentReadState.gappedStartOffset, dir, validRange);
            if (readVisitor != null && this.callback.keepParsing()) {
                readVisitor.visitBasecalls(this.currentReadState.sequence);
                readVisitor.visitEnd();
            }
        }

        public void fireEndOfContigHeader() {
            if (this.currentContigState != null) {
                this.callback = TasmFileParser.this.createCallback(this.beginContigHeaderOffset);
                this.contigVisitor = this.currentContigState.handleContigHeader(this.callback, this.visitor);
                this.currentReadState = null;
            }
            this.currentContigState = null;
        }

        public void handleEndOfContig() {
            if (this.contigVisitor != null) {
                if (this.callback.keepParsing()) {
                    this.contigVisitor.visitEnd();
                } else {
                    this.contigVisitor.halted();
                }
            }
        }
    }

    private static abstract class AbstractCallback
    implements TasmVisitor.TasmVisitorCallback {
        private volatile boolean keepParsing = true;

        private AbstractCallback() {
        }

        @Override
        public void halt() {
            this.keepParsing = false;
        }

        public boolean keepParsing() {
            return this.keepParsing;
        }
    }

    private static class NoMementoCallback
    extends AbstractCallback {
        private NoMementoCallback() {
        }

        @Override
        public boolean canCreateMemento() {
            return false;
        }

        @Override
        public TasmVisitor.TasmVisitorCallback.TasmVisitorMemento createMemento() {
            throw new UnsupportedOperationException("can not create mementos");
        }
    }

    private static final class OffsetMemento
    implements TasmVisitor.TasmVisitorCallback.TasmVisitorMemento {
        private final long offset;

        public OffsetMemento(long offset) {
            this.offset = offset;
        }

        private final long getOffset() {
            return this.offset;
        }
    }

    private static class OffsetMementoCallback
    extends AbstractCallback {
        private final long offset;

        public OffsetMementoCallback(long offset) {
            this.offset = offset;
        }

        @Override
        public boolean canCreateMemento() {
            return true;
        }

        @Override
        public TasmVisitor.TasmVisitorCallback.TasmVisitorMemento createMemento() {
            return new OffsetMemento(this.offset);
        }
    }
}

