/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jcvi.jillion.assembly.tigr.tasm.DefaultTasmFileContigDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.IndexedTasmFileDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.LargeTasmContigFileDataStore;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigDataStore;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.datastore.DataStoreFilters;
import org.jcvi.jillion.core.datastore.DataStoreProviderHint;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.residue.nt.NucleotideSequenceDataStore;
import org.jcvi.jillion.fasta.nt.NucleotideFastaDataStore;

public class TasmContigFileDataStoreBuilder {
    private final File tasmFile;
    private DataStoreFilter filter = DataStoreFilters.alwaysAccept();
    private DataStoreProviderHint hint = DataStoreProviderHint.RANDOM_ACCESS_OPTIMIZE_SPEED;
    private final DataStore<Long> fullSeqLengthDataStore;

    public TasmContigFileDataStoreBuilder(File tasmFile, NucleotideFastaDataStore fullLengthSequenceDataStore) throws IOException {
        if (tasmFile == null) {
            throw new NullPointerException("tasm file can not be null");
        }
        if (!tasmFile.exists()) {
            throw new FileNotFoundException("tasm file must exist");
        }
        if (!tasmFile.canRead()) {
            throw new IOException("contig file is not readable");
        }
        if (fullLengthSequenceDataStore == null) {
            throw new NullPointerException("sequence datastore can not be null");
        }
        this.tasmFile = tasmFile;
        this.fullSeqLengthDataStore = this.adapt(fullLengthSequenceDataStore);
    }

    public TasmContigFileDataStoreBuilder(File tasmFile, NucleotideSequenceDataStore fullLengthSequenceDataStore) throws IOException {
        if (tasmFile == null) {
            throw new NullPointerException("tasm file can not be null");
        }
        if (!tasmFile.exists()) {
            throw new FileNotFoundException("tasm file must exist");
        }
        if (!tasmFile.canRead()) {
            throw new IOException("tasm file is not readable");
        }
        if (fullLengthSequenceDataStore == null) {
            throw new NullPointerException("sequence datastore can not be null");
        }
        this.tasmFile = tasmFile;
        this.fullSeqLengthDataStore = this.adapt(fullLengthSequenceDataStore);
    }

    private DataStore<Long> adapt(NucleotideFastaDataStore fullLengthSequenceDataStore) {
        return DataStore.adapt(DataStore.class, fullLengthSequenceDataStore, from -> ((NucleotideSequence)from.getSequence()).getUngappedLength());
    }

    private DataStore<Long> adapt(NucleotideSequenceDataStore fullLengthSequenceDataStore) {
        return DataStore.adapt(DataStore.class, fullLengthSequenceDataStore, from -> from.getUngappedLength());
    }

    public TasmContigFileDataStoreBuilder filter(DataStoreFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter can not be null");
        }
        this.filter = filter;
        return this;
    }

    public TasmContigFileDataStoreBuilder hint(DataStoreProviderHint hint) {
        if (hint == null) {
            throw new NullPointerException("hint can not be null");
        }
        this.hint = hint;
        return this;
    }

    public TasmContigDataStore build() throws IOException {
        switch (this.hint) {
            case RANDOM_ACCESS_OPTIMIZE_SPEED: {
                return DefaultTasmFileContigDataStore.create(this.tasmFile, this.fullSeqLengthDataStore, this.filter);
            }
            case RANDOM_ACCESS_OPTIMIZE_MEMORY: {
                return IndexedTasmFileDataStore.create(this.tasmFile, this.fullSeqLengthDataStore, this.filter);
            }
            case ITERATION_ONLY: {
                return new LargeTasmContigFileDataStore(this.tasmFile, this.fullSeqLengthDataStore, this.filter);
            }
        }
        throw new IllegalArgumentException("unknown provider hint : " + (Object)((Object)this.hint));
    }
}

