/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.io.File;
import java.io.IOException;
import org.jcvi.jillion.assembly.tigr.tasm.AbstractTasmContigBuilderVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigBuilder;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContigVisitor;
import org.jcvi.jillion.assembly.tigr.tasm.TasmFileParser;
import org.jcvi.jillion.assembly.tigr.tasm.TasmVisitor;
import org.jcvi.jillion.core.datastore.DataStore;
import org.jcvi.jillion.core.datastore.DataStoreFilter;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.core.util.iter.AbstractBlockingStreamingIterator;

final class TasmContigFileContigIterator
extends AbstractBlockingStreamingIterator<TasmContig> {
    private final File contigFile;
    private final DataStoreFilter filter;
    private final DataStore<Long> fullLengthSequences;

    public static StreamingIterator<TasmContig> create(File contigFile, DataStore<Long> fullLengthSequences, DataStoreFilter filter) {
        TasmContigFileContigIterator iter = new TasmContigFileContigIterator(contigFile, fullLengthSequences, filter);
        iter.start();
        return iter;
    }

    private TasmContigFileContigIterator(File contigFile, DataStore<Long> fullLengthSequences, DataStoreFilter filter) {
        this.contigFile = contigFile;
        this.filter = filter;
        this.fullLengthSequences = fullLengthSequences;
    }

    @Override
    protected void backgroundThreadRunMethod() throws RuntimeException {
        TasmVisitor visitor = new TasmVisitor(){

            @Override
            public void halted() {
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public TasmContigVisitor visitContig(TasmVisitor.TasmVisitorCallback callback, String contigId) {
                if (TasmContigFileContigIterator.this.filter.accept(contigId)) {
                    return new AbstractTasmContigBuilderVisitor(contigId, TasmContigFileContigIterator.this.fullLengthSequences){

                        @Override
                        protected void visitRecord(TasmContigBuilder contig) {
                            TasmContigFileContigIterator.this.blockingPut(contig.build());
                        }
                    };
                }
                return null;
            }
        };
        try {
            TasmFileParser.create(this.contigFile).parse(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException("error parsing contig file", e);
        }
    }
}

