/*
 * Decompiled with CFR 0.152.
 */
package org.jcvi.jillion.assembly.tigr.tasm;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jcvi.jillion.assembly.AbstractContigBuilder;
import org.jcvi.jillion.assembly.AssembledRead;
import org.jcvi.jillion.assembly.AssembledReadBuilder;
import org.jcvi.jillion.assembly.Contig;
import org.jcvi.jillion.assembly.tigr.tasm.DefaultTasmAssembledRead;
import org.jcvi.jillion.assembly.tigr.tasm.TasmAssembledRead;
import org.jcvi.jillion.assembly.tigr.tasm.TasmAssembledReadAdapter;
import org.jcvi.jillion.assembly.tigr.tasm.TasmAssembledReadBuilder;
import org.jcvi.jillion.assembly.tigr.tasm.TasmContig;
import org.jcvi.jillion.core.Direction;
import org.jcvi.jillion.core.Range;
import org.jcvi.jillion.core.io.IOUtil;
import org.jcvi.jillion.core.residue.nt.NucleotideSequence;
import org.jcvi.jillion.core.util.MapUtil;
import org.jcvi.jillion.core.util.iter.StreamingIterator;
import org.jcvi.jillion.internal.assembly.DefaultContig;

public final class TasmContigBuilder
extends AbstractContigBuilder<TasmAssembledRead, TasmContig> {
    private Long celeraAssemblerId;
    private String comment;
    private String commonName;
    private Integer sampleId;
    private Long asmblId;
    private String editPerson;
    private Long editDate;
    private String assemblyMethod;
    private boolean isCircular;
    private Double avgCoverage;
    private Integer numberOfReads;

    public TasmContigBuilder(String id, NucleotideSequence consensus) {
        super(id, consensus);
        try {
            long asmblId = Long.parseLong(id);
            if (asmblId > 0L) {
                this.setTigrProjectAssemblyId(asmblId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TasmContigBuilder(Contig<? extends AssembledRead> copy) {
        this(copy.getId(), copy.getConsensusSequence());
        StreamingIterator<? extends AssembledRead> iter = null;
        try {
            iter = copy.getReadIterator();
            while (iter.hasNext()) {
                AssembledRead read = iter.next();
                this.addRead(new TasmAssembledReadAdapter(read));
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TasmContigBuilder(TasmContig copy) {
        this(copy.getId(), copy.getConsensusSequence());
        StreamingIterator iter = null;
        try {
            iter = copy.getReadIterator();
            while (iter.hasNext()) {
                TasmAssembledRead read = (TasmAssembledRead)iter.next();
                this.addRead(read);
            }
        }
        finally {
            IOUtil.closeAndIgnoreErrors(iter);
        }
        this.celeraAssemblerId = copy.getCeleraAssemblerId();
        this.sampleId = copy.getSampleId();
        this.asmblId = copy.getTigrProjectAssemblyId();
        this.assemblyMethod = copy.getAssemblyMethod();
        this.comment = copy.getComment();
        this.commonName = copy.getCommonName();
        this.editDate = copy.getEditDate().getTime();
        this.editPerson = copy.getEditPerson();
        this.isCircular = copy.isCircular();
        if ((double)copy.getNumberOfReads() == 0.0) {
            this.avgCoverage = copy.getAvgCoverage();
        }
    }

    public TasmContigBuilder addRead(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
        if (offset < 0) {
            throw new IllegalArgumentException("circular reads not supported");
        }
        super.addRead(id, offset, validRange, basecalls, dir, fullUngappedLength);
        return this;
    }

    @Override
    public Collection<TasmAssembledReadBuilder> getAllAssembledReadBuilders() {
        return super.getAllAssembledReadBuilders();
    }

    public TasmAssembledReadBuilder getAssembledReadBuilder(String readId) {
        return (TasmAssembledReadBuilder)super.getAssembledReadBuilder(readId);
    }

    public TasmContigBuilder withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public TasmContigBuilder withCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    public TasmContigBuilder setCoverageInfo(Integer numberOfReads, Double avgCoverage) {
        if (numberOfReads != null && numberOfReads < 0) {
            throw new IllegalArgumentException("number of reads must be >= 0");
        }
        if (avgCoverage != null && avgCoverage < 0.0) {
            throw new IllegalArgumentException("avg coverage must be >= 0");
        }
        this.avgCoverage = avgCoverage;
        this.numberOfReads = numberOfReads;
        return this;
    }

    public TasmContigBuilder withCeleraAssemblerContigId(Long caId) {
        this.celeraAssemblerId = caId == null ? null : caId;
        return this;
    }

    public TasmContigBuilder setSampleId(String sampleId) {
        this.sampleId = sampleId == null ? null : Integer.valueOf(Integer.parseInt(sampleId));
        return this;
    }

    public TasmContigBuilder withMethod(String method) {
        this.assemblyMethod = method;
        return this;
    }

    public TasmContigBuilder withEditInfo(String editPerson, Date editDate) {
        if (editPerson == null || editDate == null) {
            this.editPerson = null;
            this.editDate = null;
        } else {
            this.editDate = editDate.getTime();
            this.editPerson = editPerson;
        }
        return this;
    }

    public TasmContigBuilder isCircular(boolean isCircular) {
        this.isCircular = isCircular;
        return this;
    }

    public TasmContigBuilder setTigrProjectAssemblyId(Long asmblId) {
        this.asmblId = asmblId;
        return this;
    }

    @Override
    public DefaultTasmContig build() {
        if (this.consensusCaller != null) {
            this.recallConsensusNow();
        }
        int capacity = MapUtil.computeMinHashMapSizeWithoutRehashing(this.numberOfReads());
        LinkedHashMap reads = new LinkedHashMap(capacity);
        NucleotideSequence consensus = this.getConsensusBuilder().build();
        for (AssembledReadBuilder assembledReadBuilder : this.getAllAssembledReadBuilders()) {
            reads.put(assembledReadBuilder.getId(), assembledReadBuilder.build(consensus));
        }
        return new DefaultTasmContig(this, consensus, reads, this.avgCoverage, this.numberOfReads);
    }

    protected TasmAssembledReadBuilder createPlacedReadBuilder(TasmAssembledRead read) {
        TasmAssembledReadBuilder builder = DefaultTasmAssembledRead.createBuilder(read.getId(), read.getNucleotideSequence().toString(), (int)read.getGappedStartOffset(), read.getDirection(), read.getReadInfo().getValidRange(), read.getReadInfo().getUngappedFullLength());
        return builder;
    }

    protected TasmAssembledReadBuilder createPlacedReadBuilder(String id, int offset, Range validRange, String basecalls, Direction dir, int fullUngappedLength) {
        return DefaultTasmAssembledRead.createBuilder(id, basecalls, offset, dir, validRange, fullUngappedLength);
    }

    private static final class DefaultTasmContig
    implements TasmContig {
        private final Long celeraAssemblerId;
        private final String comment;
        private final String commonName;
        private final Integer sampleId;
        private final Long asmblId;
        private final String editPerson;
        private final Long editDate;
        private final String assemblyMethod;
        private final double avgCoverage;
        private final boolean isCircular;
        private final int numberOfReads;
        private final Contig<TasmAssembledRead> contig;

        private DefaultTasmContig(TasmContigBuilder builder, NucleotideSequence consensus, Map<String, TasmAssembledRead> reads, Double userProvidedAvgCoverage, Integer userProvidedNumberOfReads) {
            this.contig = new DefaultContig<TasmAssembledRead>(builder.getContigId(), consensus, reads);
            int n = this.numberOfReads = userProvidedNumberOfReads == null ? (int)this.contig.getNumberOfReads() : userProvidedNumberOfReads;
            if (userProvidedAvgCoverage == null) {
                if (this.numberOfReads > 0) {
                    long totalNumberOfReadBases = 0L;
                    for (TasmAssembledRead read : reads.values()) {
                        totalNumberOfReadBases += read.getNucleotideSequence().getUngappedLength();
                    }
                    this.avgCoverage = (double)totalNumberOfReadBases / (double)this.contig.getConsensusSequence().getUngappedLength();
                } else {
                    this.avgCoverage = 0.0;
                }
            } else {
                this.avgCoverage = userProvidedAvgCoverage;
            }
            this.sampleId = builder.sampleId;
            this.celeraAssemblerId = builder.celeraAssemblerId;
            this.editDate = builder.editDate;
            this.editPerson = builder.editPerson;
            this.comment = builder.comment;
            this.commonName = builder.commonName;
            this.assemblyMethod = builder.assemblyMethod;
            this.isCircular = builder.isCircular;
            this.asmblId = builder.asmblId;
        }

        @Override
        public boolean isAnnotationContig() {
            return this.contig.getNumberOfReads() == 0L;
        }

        @Override
        public String getId() {
            return this.contig.getId();
        }

        @Override
        public double getAvgCoverage() {
            return this.avgCoverage;
        }

        @Override
        public Integer getSampleId() {
            return this.sampleId;
        }

        @Override
        public Long getCeleraAssemblerId() {
            return this.celeraAssemblerId;
        }

        @Override
        public Long getTigrProjectAssemblyId() {
            return this.asmblId;
        }

        @Override
        public String getAssemblyMethod() {
            return this.assemblyMethod;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public String getCommonName() {
            return this.commonName;
        }

        @Override
        public String getEditPerson() {
            return this.editPerson;
        }

        @Override
        public Date getEditDate() {
            return new Date(this.editDate);
        }

        @Override
        public boolean isCircular() {
            return this.isCircular;
        }

        @Override
        public long getNumberOfReads() {
            return this.numberOfReads;
        }

        @Override
        public NucleotideSequence getConsensusSequence() {
            return this.contig.getConsensusSequence();
        }

        @Override
        public TasmAssembledRead getRead(String id) {
            return this.contig.getRead(id);
        }

        @Override
        public boolean containsRead(String readId) {
            return this.contig.containsRead(readId);
        }

        @Override
        public StreamingIterator<TasmAssembledRead> getReadIterator() {
            return this.contig.getReadIterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.asmblId == null ? 0 : this.asmblId.hashCode());
            result = 31 * result + (this.assemblyMethod == null ? 0 : this.assemblyMethod.hashCode());
            long temp = Double.doubleToLongBits(this.avgCoverage);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.celeraAssemblerId == null ? 0 : this.celeraAssemblerId.hashCode());
            result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
            result = 31 * result + (this.commonName == null ? 0 : this.commonName.hashCode());
            result = 31 * result + (this.contig == null ? 0 : this.contig.hashCode());
            result = 31 * result + (this.editDate == null ? 0 : this.editDate.hashCode());
            result = 31 * result + (this.editPerson == null ? 0 : this.editPerson.hashCode());
            result = 31 * result + (this.isCircular ? 1231 : 1237);
            result = 31 * result + (this.sampleId == null ? 0 : this.sampleId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TasmContig)) {
                return false;
            }
            TasmContig other = (TasmContig)obj;
            if (!this.contig.getId().equals(other.getId())) {
                return false;
            }
            if (!this.contig.getConsensusSequence().equals(other.getConsensusSequence())) {
                return false;
            }
            if (this.contig.getNumberOfReads() != other.getNumberOfReads()) {
                return false;
            }
            if (!this.readsMatch(other)) {
                return false;
            }
            if (this.asmblId == null ? other.getTigrProjectAssemblyId() != null : !this.asmblId.equals(other.getTigrProjectAssemblyId())) {
                return false;
            }
            if (this.assemblyMethod == null ? other.getAssemblyMethod() != null : !this.assemblyMethod.equals(other.getAssemblyMethod())) {
                return false;
            }
            if (Double.doubleToLongBits(this.avgCoverage) != Double.doubleToLongBits(other.getAvgCoverage())) {
                return false;
            }
            if (this.celeraAssemblerId == null ? other.getCeleraAssemblerId() != null : !this.celeraAssemblerId.equals(other.getCeleraAssemblerId())) {
                return false;
            }
            if (this.comment == null ? other.getComment() != null : !this.comment.equals(other.getComment())) {
                return false;
            }
            if (this.commonName == null ? other.getCommonName() != null : !this.commonName.equals(other.getCommonName())) {
                return false;
            }
            if (this.editDate == null ? other.getEditDate() != null : this.editDate.longValue() != other.getEditDate().getTime()) {
                return false;
            }
            if (this.editPerson == null ? other.getEditPerson() != null : !this.editPerson.equals(other.getEditPerson())) {
                return false;
            }
            if (this.isCircular != other.isCircular()) {
                return false;
            }
            return !(this.sampleId == null ? other.getSampleId() != null : !this.sampleId.equals(other.getSampleId()));
        }

        private boolean readsMatch(TasmContig other) {
            try (StreamingIterator<TasmAssembledRead> readIter = this.contig.getReadIterator();){
                while (readIter.hasNext()) {
                    TasmAssembledRead read = readIter.next();
                    String readId = read.getId();
                    if (!other.containsRead(readId)) {
                        boolean bl = false;
                        return bl;
                    }
                    if (read.equals(other.getRead(readId))) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
    }
}

